/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen.test;

import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.capture.Capture;
import io.github.mortuusars.exposure.client.capture.action.CaptureAction;
import io.github.mortuusars.exposure.client.capture.palettizer.Palettizer;
import io.github.mortuusars.exposure.client.gui.screen.test.ShutterSpeedSlider;
import io.github.mortuusars.exposure.client.gui.screen.test.Slider;
import io.github.mortuusars.exposure.client.image.Image;
import io.github.mortuusars.exposure.client.image.modifier.ImageEffect;
import io.github.mortuusars.exposure.client.image.renderable.RenderableImage;
import io.github.mortuusars.exposure.client.render.image.RenderCoordinates;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.data.ColorPalette;
import io.github.mortuusars.exposure.data.ColorPalettes;
import io.github.mortuusars.exposure.util.UnixTimestamp;
import io.github.mortuusars.exposure.util.color.Color;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import io.github.mortuusars.exposure.world.camera.film.properties.Levels;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class TestImageScreen
extends Screen {
    protected float scale = 1.0f;
    protected boolean isCapturing;
    @Nullable
    protected Image image;
    @Nullable
    protected RenderableImage renderableImage;
    protected List<AbstractWidget> rightPaneWidgets = new ArrayList<AbstractWidget>();
    protected Slider sizeSlider;
    protected ShutterSpeedSlider shutterSpeedSlider;
    protected Slider exposureSlider;
    protected Slider contrastSlider;
    protected Slider shadowsSlider;
    protected Slider midtonesSlider;
    protected Slider highlightsSlider;
    protected Slider blackSlider;
    protected Slider whiteSlider;
    protected Slider balanceRedSlider;
    protected Slider balanceGreenSlider;
    protected Slider balanceBlueSlider;
    protected Slider hueSlider;
    protected Slider saturationSlider;
    protected Slider brightnessSlider;
    protected Slider noiseSlider;
    protected Checkbox bw;
    protected Checkbox aged;
    protected float rightPaneScroll = 0.0f;
    protected long applyEditsAt = -1L;

    public TestImageScreen() {
        super((Component)Component.empty());
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        int sliderWidth = 120;
        int sliderHeight = 15;
        int spacingInGroup = 1;
        int spacingBetweenGroups = 4;
        int screenEdgeMargin = 5;
        int labelXOffset = 3;
        int x = this.width - sliderWidth - screenEdgeMargin;
        int labelX = x + labelXOffset;
        int y = screenEdgeMargin;
        this.rightPaneWidgets.clear();
        this.sizeSlider = new Slider(x, y, sliderWidth, sliderHeight, 320.0, 1.0, 2048.0, 0, "Size", v -> this.onChanged());
        this.addRenderableWidget((GuiEventListener)this.sizeSlider);
        this.rightPaneWidgets.add(this.sizeSlider);
        y += this.sizeSlider.getHeight();
        MultiLineTextWidget toneLabel = new MultiLineTextWidget(labelX, y += spacingBetweenGroups, (Component)Component.literal((String)"Tone"), this.font);
        this.addRenderableOnly((Renderable)toneLabel);
        this.rightPaneWidgets.add((AbstractWidget)toneLabel);
        Objects.requireNonNull(this.font);
        this.shutterSpeedSlider = new ShutterSpeedSlider(x, y += 9, sliderWidth, sliderHeight, "Shutter Speed", Exposure.Items.CAMERA.get().getAvailableShutterSpeeds(), ShutterSpeed.DEFAULT, v -> this.onChanged());
        this.shutterSpeedSlider.setHorizontalGradient(0x44000000, 0x44FFFFFF);
        this.addRenderableWidget((GuiEventListener)this.shutterSpeedSlider);
        this.rightPaneWidgets.add(this.shutterSpeedSlider);
        y += this.shutterSpeedSlider.getHeight();
        this.exposureSlider = new Slider(x, y += spacingInGroup, sliderWidth, sliderHeight, 0.0, -4.0, 4.0, 2, "Sensitivity", v -> this.onChanged());
        this.exposureSlider.setHorizontalGradient(0x44000000, 0x44FFFFFF);
        this.addRenderableWidget((GuiEventListener)this.exposureSlider);
        this.rightPaneWidgets.add(this.exposureSlider);
        y += this.exposureSlider.getHeight();
        this.contrastSlider = new Slider(x, y += spacingInGroup, sliderWidth, sliderHeight, 0.0, -1.0, 1.0, 2, "Contrast", v -> this.onChanged());
        this.contrastSlider.setHorizontalGradient(0x44FFFFFF, 0x44000000);
        this.addRenderableWidget((GuiEventListener)this.contrastSlider);
        this.rightPaneWidgets.add(this.contrastSlider);
        y += this.contrastSlider.getHeight();
        MultiLineTextWidget levelsLabel = new MultiLineTextWidget(labelX, y += spacingBetweenGroups, (Component)Component.literal((String)"Levels"), this.font);
        this.addRenderableOnly((Renderable)levelsLabel);
        this.rightPaneWidgets.add((AbstractWidget)levelsLabel);
        Objects.requireNonNull(this.font);
        this.shadowsSlider = new Slider(x, y += 9, sliderWidth, sliderHeight, 0.0, 0.0, 255.0, 0, "Shadows", v -> this.onChanged());
        this.shadowsSlider.setHorizontalGradient(0x44FFFFFF, 0x44000000);
        this.addRenderableWidget((GuiEventListener)this.shadowsSlider);
        this.rightPaneWidgets.add(this.shadowsSlider);
        y += this.shadowsSlider.getHeight();
        this.midtonesSlider = new Slider(x, y += spacingInGroup, sliderWidth, sliderHeight, 128.0, 0.0, 255.0, 0, "Midtones", v -> this.onChanged());
        this.midtonesSlider.setHorizontalGradient(0x44FFFFFF, 0x44000000);
        this.addRenderableWidget((GuiEventListener)this.midtonesSlider);
        this.rightPaneWidgets.add(this.midtonesSlider);
        y += this.shadowsSlider.getHeight();
        this.highlightsSlider = new Slider(x, y += spacingInGroup, sliderWidth, sliderHeight, 255.0, 0.0, 255.0, 0, "Highlights", v -> this.onChanged());
        this.highlightsSlider.setHorizontalGradient(0x44FFFFFF, 0x44000000);
        this.addRenderableWidget((GuiEventListener)this.highlightsSlider);
        this.rightPaneWidgets.add(this.highlightsSlider);
        y += this.shadowsSlider.getHeight();
        this.blackSlider = new Slider(x, y += spacingInGroup, sliderWidth, sliderHeight, 0.0, 0.0, 255.0, 0, "Black", v -> this.onChanged());
        this.blackSlider.setHorizontalGradient(0x44000000, 0x44FFFFFF);
        this.addRenderableWidget((GuiEventListener)this.blackSlider);
        this.rightPaneWidgets.add(this.blackSlider);
        y += this.shadowsSlider.getHeight();
        this.whiteSlider = new Slider(x, y += spacingInGroup, sliderWidth, sliderHeight, 255.0, 0.0, 255.0, 0, "White", v -> this.onChanged());
        this.whiteSlider.setHorizontalGradient(0x44000000, 0x44FFFFFF);
        this.addRenderableWidget((GuiEventListener)this.whiteSlider);
        this.rightPaneWidgets.add(this.whiteSlider);
        y += this.shadowsSlider.getHeight();
        MultiLineTextWidget hsbLabel = new MultiLineTextWidget(labelX, y += spacingBetweenGroups, (Component)Component.literal((String)"HSB"), this.font);
        this.addRenderableOnly((Renderable)hsbLabel);
        this.rightPaneWidgets.add((AbstractWidget)hsbLabel);
        Objects.requireNonNull(this.font);
        this.hueSlider = new Slider(x, y += 9, sliderWidth, sliderHeight, 0.0, -1.0, 1.0, 2, "Hue", v -> this.onChanged());
        this.hueSlider.setHorizontalGradient(0x44FF0000, 0x44FF00FF);
        this.addRenderableWidget((GuiEventListener)this.hueSlider);
        this.rightPaneWidgets.add(this.hueSlider);
        y += this.shadowsSlider.getHeight();
        this.saturationSlider = new Slider(x, y += spacingInGroup, sliderWidth, sliderHeight, 0.0, -1.0, 1.0, 2, "Saturation", v -> this.onChanged());
        this.saturationSlider.setHorizontalGradient(0x44777777, 1157571089);
        this.addRenderableWidget((GuiEventListener)this.saturationSlider);
        this.rightPaneWidgets.add(this.saturationSlider);
        y += this.shadowsSlider.getHeight();
        this.brightnessSlider = new Slider(x, y += spacingInGroup, sliderWidth, sliderHeight, 0.0, -1.0, 1.0, 2, "Brightness", v -> this.onChanged());
        this.brightnessSlider.setHorizontalGradient(0x44000000, 0x44FFFFFF);
        this.addRenderableWidget((GuiEventListener)this.brightnessSlider);
        this.rightPaneWidgets.add(this.brightnessSlider);
        y += this.shadowsSlider.getHeight();
        MultiLineTextWidget colorBalanceLabel = new MultiLineTextWidget(labelX, y += spacingBetweenGroups, (Component)Component.literal((String)"Color Balance"), this.font);
        this.addRenderableOnly((Renderable)colorBalanceLabel);
        this.rightPaneWidgets.add((AbstractWidget)colorBalanceLabel);
        Objects.requireNonNull(this.font);
        this.balanceRedSlider = new Slider(x, y += 9, sliderWidth, sliderHeight, 0.0, -1.0, 1.0, 2, "Red", v -> this.onChanged());
        this.balanceRedSlider.setHorizontalGradient(0x4400FFFF, 0x44FF0000);
        this.addRenderableWidget((GuiEventListener)this.balanceRedSlider);
        this.rightPaneWidgets.add(this.balanceRedSlider);
        y += this.shadowsSlider.getHeight();
        this.balanceGreenSlider = new Slider(x, y += spacingInGroup, sliderWidth, sliderHeight, 0.0, -1.0, 1.0, 2, "Green", v -> this.onChanged());
        this.balanceGreenSlider.setHorizontalGradient(0x44FF00FF, 0x4400FF00);
        this.addRenderableWidget((GuiEventListener)this.balanceGreenSlider);
        this.rightPaneWidgets.add(this.balanceGreenSlider);
        y += this.shadowsSlider.getHeight();
        this.balanceBlueSlider = new Slider(x, y += spacingInGroup, sliderWidth, sliderHeight, 0.0, -1.0, 1.0, 2, "Blue", v -> this.onChanged());
        this.balanceBlueSlider.setHorizontalGradient(0x44FFFF00, 0x440000FF);
        this.addRenderableWidget((GuiEventListener)this.balanceBlueSlider);
        this.rightPaneWidgets.add(this.balanceBlueSlider);
        y += this.shadowsSlider.getHeight();
        MultiLineTextWidget effectsLabel = new MultiLineTextWidget(labelX, y += spacingBetweenGroups, (Component)Component.literal((String)"Effects"), this.font);
        this.addRenderableOnly((Renderable)effectsLabel);
        this.rightPaneWidgets.add((AbstractWidget)effectsLabel);
        Objects.requireNonNull(this.font);
        this.noiseSlider = new Slider(x, y += 9, sliderWidth, sliderHeight, 0.0, 0.0, 1.0, 2, "Noise", v -> this.onChanged());
        this.noiseSlider.setHorizontalGradient(0x44777777, 0x44FFFFFF);
        this.addRenderableWidget((GuiEventListener)this.noiseSlider);
        this.rightPaneWidgets.add(this.noiseSlider);
        y += this.shadowsSlider.getHeight();
        this.bw = Checkbox.builder((Component)Component.literal((String)"BW"), (Font)this.font).pos(x, y += spacingBetweenGroups).onValueChange((checkbox, bl) -> this.onChanged()).build();
        this.addRenderableWidget((GuiEventListener)this.bw);
        this.rightPaneWidgets.add((AbstractWidget)this.bw);
        this.aged = Checkbox.builder((Component)Component.literal((String)"AGED"), (Font)this.font).pos(x + this.bw.getWidth() + 8, y).onValueChange((checkbox, bl) -> this.onChanged()).build();
        this.addRenderableWidget((GuiEventListener)this.aged);
        this.rightPaneWidgets.add((AbstractWidget)this.aged);
        Button capture = Button.builder((Component)Component.literal((String)"CAPTURE"), b -> this.capture()).size(60, 20).pos(screenEdgeMargin, this.height - 20 - screenEdgeMargin).build();
        this.addRenderableWidget((GuiEventListener)capture);
        if (this.image == null) {
            this.capture();
        }
    }

    protected void capture() {
        if (this.isCapturing) {
            Minecrft.get().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)Exposure.SoundEvents.CAMERA_GENERIC_CLICK.get(), (float)1.0f));
            Minecrft.player().displayClientMessage((Component)Component.literal((String)"Capture is in progress."), false);
            return;
        }
        this.isCapturing = true;
        Minecrft.get().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)Exposure.SoundEvents.SHUTTER_OPEN.get(), (float)1.0f));
        ExposureClient.cycles().enqueueTask(Capture.of(Capture.screenshot(), CaptureAction.hideGui()).handleErrorAndGetResult(err -> Minecrft.execute(() -> Minecrft.player().displayClientMessage((Component)err.casual().withStyle(ChatFormatting.RED), false))).thenAsync(ImageEffect.Crop.SQUARE_CENTER::modify).onError(err -> Minecrft.execute(() -> Minecrft.player().displayClientMessage((Component)err.casual().withStyle(ChatFormatting.RED), false))).accept(this::setImage));
    }

    protected void applyEdits() {
        if (this.renderableImage == null) {
            Minecrft.get().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)Exposure.SoundEvents.CAMERA_GENERIC_CLICK.get(), (float)1.0f));
            Minecrft.player().displayClientMessage((Component)Component.literal((String)"No image to modify."), false);
            return;
        }
        try {
            this.renderableImage = RenderableImage.of("test_image", this.image).modifyWith(ImageEffect.Resize.to(this.sizeSlider.getValue().intValue())).modifyWith(ImageEffect.exposure(this.shutterSpeedSlider.getShutterSpeed().getBrightness() * (this.exposureSlider.getValue().floatValue() + 1.0f))).modifyWith(ImageEffect.contrast(this.contrastSlider.getValue().floatValue())).modifyWith(ImageEffect.levels(new Levels(this.shadowsSlider.getValue().intValue(), this.midtonesSlider.getValue().intValue(), this.highlightsSlider.getValue().intValue(), this.blackSlider.getValue().intValue(), this.whiteSlider.getValue().intValue()))).modifyWith(ImageEffect.hsb(this.hueSlider.getValue().floatValue(), this.saturationSlider.getValue().floatValue(), this.brightnessSlider.getValue().floatValue())).modifyWith(ImageEffect.colorBalance(this.balanceRedSlider.getValue().floatValue(), this.balanceGreenSlider.getValue().floatValue(), this.balanceBlueSlider.getValue().floatValue())).modifyWith(ImageEffect.noise(this.noiseSlider.getValue().floatValue())).modifyWith(ImageEffect.optional(this.bw.selected(), ImageEffect.BLACK_AND_WHITE)).modifyWith(image -> Palettizer.DITHERED.palettize((Image)image, (ColorPalette)ColorPalettes.getDefault(Minecrft.registryAccess()).value()), "palette").modifyWith(ImageEffect.optional(this.aged.selected(), ImageEffect.AGED));
            ExposureClient.imageRenderer().clearCacheOf("test_image");
        }
        catch (Exception e) {
            Minecrft.get().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)Exposure.SoundEvents.CAMERA_GENERIC_CLICK.get(), (float)1.0f));
            Minecrft.player().displayClientMessage((Component)Component.literal((String)("Failed to apply edits. " + e.getMessage())), false);
            Exposure.LOGGER.error("Failed to apply edits: ", (Throwable)e);
        }
        this.applyEditsAt = -1L;
    }

    protected void onChanged() {
        this.applyEditsAt = UnixTimestamp.Milliseconds.now();
    }

    private void setImage(Image image) {
        if (this.image != null) {
            this.image.close();
        }
        if (this.renderableImage != null) {
            this.renderableImage.close();
        }
        this.image = image;
        this.renderableImage = RenderableImage.of("test_image", image);
        this.applyEdits();
        ExposureClient.imageRenderer().clearCacheOf("test_image");
        Minecrft.get().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)Exposure.SoundEvents.SHUTTER_CLOSE.get(), (float)1.0f));
        this.isCapturing = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.fillHorizontalGradient(guiGraphics, this.width - 100, -500, this.width, this.height + 500, 0, -1156509423);
        if (this.isCapturing) {
            String txt = "Capturing...";
            guiGraphics.drawString(this.font, txt, this.width / 2 - this.font.width(txt) / 2, this.height / 2 - 4, -1);
            return;
        }
        if (this.renderableImage == null) {
            String txt = "<No Image>";
            guiGraphics.drawString(this.font, txt, this.width / 2 - this.font.width(txt) / 2, this.height / 2 - 4, -1);
            return;
        }
        if (this.applyEditsAt > 0L && UnixTimestamp.Milliseconds.now() >= this.applyEditsAt) {
            this.applyEdits();
        }
        guiGraphics.pose().pushPose();
        float size = (float)this.height * 0.8f * this.scale;
        guiGraphics.pose().translate((float)this.width / 2.0f - size / 2.0f, (float)this.height / 2.0f - size / 2.0f, -100.0f);
        float borderPercent = 0.02f;
        guiGraphics.fill(Mth.floor((float)(-size * borderPercent)), Mth.floor((float)(-size * borderPercent)), Mth.ceil((float)(size + size * borderPercent)), Mth.ceil((float)(size + size * borderPercent)), -1);
        guiGraphics.pose().scale(size, size, size);
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        ExposureClient.imageRenderer().render(this.renderableImage, guiGraphics.pose(), (MultiBufferSource)bufferSource, RenderCoordinates.DEFAULT, Color.WHITE);
        bufferSource.endBatch();
        guiGraphics.pose().popPose();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        int value = Mth.sign((double)scrollY);
        if (mouseX > (double)(this.width - 100) && !this.rightPaneWidgets.isEmpty()) {
            int yChange = value * 14;
            if (yChange > 0 && this.rightPaneWidgets.getFirst().getY() >= 5) {
                return true;
            }
            if (yChange < 0 && this.rightPaneWidgets.getLast().getY() + this.rightPaneWidgets.getLast().getHeight() <= this.height - 5) {
                return true;
            }
            for (AbstractWidget widget : this.rightPaneWidgets) {
                widget.setY(widget.getY() + yChange);
                if (widget.getY() < 5 || widget.getY() + widget.getHeight() > this.height - 5) {
                    widget.visible = false;
                    continue;
                }
                widget.visible = true;
            }
            return true;
        }
        this.scale = Mth.clamp((float)(this.scale + 0.2f * (float)value), (float)0.2f, (float)2.0f);
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (button != 1) {
            return false;
        }
        double fov = ((Integer)Minecrft.options().fov().get()).intValue();
        int windowWidth = Minecrft.get().getWindow().getHeight();
        int windowHeight = Minecrft.get().getWindow().getHeight();
        double xRot = dragY / (double)windowHeight * fov;
        double yRot = dragX / (double)windowWidth * (fov * ((double)windowHeight / (double)windowWidth));
        Minecrft.player().turn(-yRot * 20.0, -xRot * 20.0);
        return true;
    }

    private void fillHorizontalGradient(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int colorFrom, int colorTo) {
        VertexConsumer consumer = guiGraphics.bufferSource().getBuffer(RenderType.gui());
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        consumer.addVertex(matrix4f, (float)x1, (float)y1, 0.0f).setColor(colorFrom);
        consumer.addVertex(matrix4f, (float)x1, (float)y2, 0.0f).setColor(colorFrom);
        consumer.addVertex(matrix4f, (float)x2, (float)y2, 0.0f).setColor(colorTo);
        consumer.addVertex(matrix4f, (float)x2, (float)y1, 0.0f).setColor(colorTo);
    }
}

