/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.camera.viewfinder;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.client.camera.viewfinder.Viewfinder;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewfinderRegistry {
    private static final Map<CameraItem, Function<Camera, Viewfinder>> VIEWFINDERS = new HashMap<CameraItem, Function<Camera, Viewfinder>>();

    public static void register(CameraItem item, Function<Camera, Viewfinder> viewfinder) {
        Preconditions.checkState((!VIEWFINDERS.containsKey((Object)item) ? 1 : 0) != 0, (String)"Viewfinder for item '%s' is already registered.", (Object)((Object)item));
        VIEWFINDERS.put(item, viewfinder);
    }

    public static Function<Camera, Viewfinder> getConstructor(CameraItem item) {
        @Nullable Function<Camera, Viewfinder> viewfinder = VIEWFINDERS.get((Object)item);
        Preconditions.checkNotNull(viewfinder, (String)"No viewfinder for item '%s' is registered.", (Object)((Object)item));
        return viewfinder;
    }

    public static Viewfinder get(@NotNull Camera camera) {
        return (Viewfinder)ViewfinderRegistry.getConstructor((CameraItem)camera.getItemStack().getItem()).apply((Object)camera);
    }
}

