/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.camera.viewfinder;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.client.camera.CameraClient;
import io.github.mortuusars.exposure.client.camera.viewfinder.ViewfinderCameraControlsScreen;
import io.github.mortuusars.exposure.client.camera.viewfinder.ViewfinderOverlay;
import io.github.mortuusars.exposure.client.camera.viewfinder.ViewfinderSelfie;
import io.github.mortuusars.exposure.client.camera.viewfinder.ViewfinderShader;
import io.github.mortuusars.exposure.client.camera.viewfinder.ViewfinderZoom;
import io.github.mortuusars.exposure.client.input.Key;
import io.github.mortuusars.exposure.client.input.KeyBindings;
import io.github.mortuusars.exposure.client.input.KeyboardHandler;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import java.util.Optional;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Viewfinder {
    protected final Camera camera;
    protected final ViewfinderZoom zoom;
    protected final ViewfinderOverlay overlay;
    protected final ViewfinderShader shader;
    protected final ViewfinderSelfie selfie;
    protected KeyBindings keyBindings;
    @Nullable
    protected ViewfinderCameraControlsScreen controlsScreen;

    public Viewfinder(@NotNull Camera camera) {
        this.keyBindings = KeyBindings.of(Key.press(Minecrft.options().keyAttack).executes(() -> !this.canAttack()), Key.press(Minecrft.options().keyTogglePerspective).executes(() -> this.selfie().toggle()), Key.press(Minecrft.options().keyInventory).or(Key.press(256)).executes(() -> {
            Screen patt0$temp = Minecrft.get().screen;
            if (patt0$temp instanceof ViewfinderCameraControlsScreen) {
                ViewfinderCameraControlsScreen viewfinderControlsScreen = (ViewfinderCameraControlsScreen)patt0$temp;
                viewfinderControlsScreen.onClose();
                this.controlsScreen = null;
            } else {
                CameraClient.deactivate();
                this.close();
            }
        }), Key.press(KeyboardHandler.getCameraControlsKey()).onlyIf(this::isLookingThrough).onlyIf(() -> !this.controlsActive()).executes(() -> {
            this.openControlsScreen();
            return false;
        }));
        this.camera = camera;
        this.zoom = this.createZoom(camera);
        this.overlay = this.createOverlay(camera);
        this.shader = this.createShader(camera);
        this.selfie = this.createSelfie(camera);
    }

    protected ViewfinderZoom createZoom(Camera camera) {
        return new ViewfinderZoom(camera, this);
    }

    protected ViewfinderOverlay createOverlay(Camera camera) {
        return new ViewfinderOverlay(camera, this);
    }

    protected ViewfinderShader createShader(Camera camera) {
        return new ViewfinderShader(camera, this);
    }

    protected ViewfinderSelfie createSelfie(Camera camera) {
        return new ViewfinderSelfie(camera, this);
    }

    protected ViewfinderCameraControlsScreen createControlsScreen(Camera camera) {
        return new ViewfinderCameraControlsScreen(camera, this);
    }

    public Camera camera() {
        return this.camera;
    }

    public ViewfinderZoom zoom() {
        return this.zoom;
    }

    public ViewfinderOverlay overlay() {
        return this.overlay;
    }

    public ViewfinderShader shader() {
        return this.shader;
    }

    public ViewfinderSelfie selfie() {
        return this.selfie;
    }

    public Optional<ViewfinderCameraControlsScreen> controlsScreen() {
        return Optional.ofNullable(this.controlsScreen);
    }

    public void tick() {
        this.shader().update();
        this.selfie().tick();
    }

    public boolean isLookingThrough() {
        CameraType cameraType = Minecrft.options().getCameraType();
        return cameraType == CameraType.FIRST_PERSON || cameraType == CameraType.THIRD_PERSON_FRONT;
    }

    public boolean controlsActive() {
        return Minecrft.get().screen instanceof ViewfinderCameraControlsScreen;
    }

    public boolean canAttack() {
        return (Boolean)Config.Server.CAMERA_VIEWFINDER_ATTACK.get() != false && this.camera.map(CameraItem::isInSelfieMode).orElse(false) == false;
    }

    public void openControlsScreen() {
        Preconditions.checkNotNull((Object)this.camera, (Object)"No active camera");
        this.controlsScreen = this.createControlsScreen(this.camera);
        Minecrft.get().setScreen((Screen)this.controlsScreen);
    }

    public void close() {
        if (this.shader != null) {
            this.shader.close();
        }
        if (this.controlsActive()) {
            Minecrft.get().setScreen(null);
        }
    }

    public boolean keyPressed(int key, int scanCode, int action, int modifiers) {
        return action == 1 && this.keyBindings.keyPressed(key, scanCode, modifiers) || action == 0 && this.keyBindings.keyReleased(key, scanCode, modifiers) || this.zoom().keyPressed(key, scanCode, action, modifiers);
    }

    public boolean mouseClicked(int button, int action) {
        if (!this.isLookingThrough()) {
            return false;
        }
        if (this.controlsActive()) {
            return false;
        }
        if (!this.canAttack() && Minecrft.options().keyAttack.matchesMouse(button)) {
            return true;
        }
        if (KeyboardHandler.getCameraControlsKey().matchesMouse(button)) {
            this.openControlsScreen();
            return false;
        }
        if (((Boolean)Config.Client.VIEWFINDER_MIDDLE_CLICK_CONTROLS.get()).booleanValue() && button == 2) {
            this.openControlsScreen();
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double amount) {
        if (this.isLookingThrough() && !this.controlsActive()) {
            return this.zoom.mouseScrolled(amount);
        }
        return false;
    }

    public double modifyMouseSensitivity(double original) {
        if (!this.isLookingThrough()) {
            return original;
        }
        double scale = original / (double)((Integer)Minecraft.getInstance().options.fov().get()).intValue();
        double scaledSensitivity = this.zoom.getCurrentFov() * scale;
        double normalizedDifference = Mth.map((double)(original - scaledSensitivity), (double)0.0, (double)original, (double)0.0, (double)1.0);
        double influence = (Double)Config.Client.VIEWFINDER_ZOOM_SENSITIVITY_INFLUENCE.get();
        double strength = 1.0 - normalizedDifference * influence;
        strength *= strength;
        return Mth.lerp((double)strength, (double)scaledSensitivity, (double)original);
    }
}

