/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.command;

import com.hlysine.create_power_loader.content.ChunkLoadManager;
import com.hlysine.create_power_loader.content.ChunkLoader;
import com.hlysine.create_power_loader.content.LoaderMode;
import com.hlysine.create_power_loader.content.WeakCollection;
import com.hlysine.create_power_loader.content.trains.CarriageChunkLoader;
import com.hlysine.create_power_loader.content.trains.StationChunkLoader;
import com.hlysine.create_power_loader.content.trains.TrainChunkLoader;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.createmod.catnip.data.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.server.command.EnumArgument;
import org.jetbrains.annotations.Nullable;

public class ListLoadersCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list").requires(cs -> cs.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"type", (ArgumentType)EnumArgument.enumArgument(LoaderMode.class)).then(((LiteralArgumentBuilder)Commands.literal((String)"active").then(Commands.literal((String)"limit").then(Commands.argument((String)"limit", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ListLoadersCommand.handler(true, true, true))))).executes(ListLoadersCommand.handler(true, false, true)))).then(((LiteralArgumentBuilder)Commands.literal((String)"all").then(Commands.literal((String)"limit").then(Commands.argument((String)"limit", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ListLoadersCommand.handler(true, true, false))))).executes(ListLoadersCommand.handler(true, false, false))))).then(((LiteralArgumentBuilder)Commands.literal((String)"all").then(((LiteralArgumentBuilder)Commands.literal((String)"active").then(Commands.literal((String)"limit").then(Commands.argument((String)"limit", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ListLoadersCommand.handler(false, true, true))))).executes(ListLoadersCommand.handler(false, false, true)))).then(((LiteralArgumentBuilder)Commands.literal((String)"all").then(Commands.literal((String)"limit").then(Commands.argument((String)"limit", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ListLoadersCommand.handler(false, true, false))))).executes(ListLoadersCommand.handler(false, false, false))));
    }

    private static Command<CommandSourceStack> handler(boolean hasMode, boolean hasLimit, boolean activeOnly) {
        return ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ListLoadersCommand.fillReport(source.getLevel(), source.getPosition(), hasMode ? (LoaderMode)((Object)((Object)ctx.getArgument("type", LoaderMode.class))) : null, hasLimit ? (Integer)ctx.getArgument("limit", Integer.class) : 20, activeOnly, (s, f) -> source.sendSuccess(() -> Component.literal((String)s).withStyle(st -> st.withColor(f.intValue())), false), c -> source.sendSuccess(() -> c, false));
            return 1;
        };
    }

    private static void fillReport(ServerLevel level, Vec3 location, @Nullable LoaderMode mode, int limit, boolean activeOnly, BiConsumer<String, Integer> chat, Consumer<Component> chatRaw) {
        int white = ChatFormatting.WHITE.getColor();
        int gray = ChatFormatting.GRAY.getColor();
        int blue = 13885148;
        int darkBlue = 5854625;
        int orange = 16756064;
        LinkedList<ChunkLoader> loaders = new LinkedList<ChunkLoader>();
        if (mode == null) {
            for (WeakCollection<ChunkLoader> list : ChunkLoadManager.allLoaders.values()) {
                loaders.addAll(list);
            }
        } else {
            loaders.addAll((Collection)ChunkLoadManager.allLoaders.get((Object)mode));
        }
        loaders.removeIf(loader -> {
            if (loader instanceof TrainChunkLoader) {
                TrainChunkLoader trainLoader = (TrainChunkLoader)loader;
                for (CarriageChunkLoader carriageLoader : trainLoader.carriageLoaders) {
                    if (!carriageLoader.known || !carriageLoader.brass && !carriageLoader.andesite) continue;
                    return false;
                }
                return true;
            }
            if (loader instanceof StationChunkLoader) {
                StationChunkLoader stationLoader = (StationChunkLoader)loader;
                return stationLoader.attachments.size() == 0;
            }
            return false;
        });
        if (activeOnly) {
            loaders.removeIf(loader -> loader.getForcedChunks().size() == 0);
        }
        HashMap typeCache = new HashMap();
        MinecraftServer server = level.getServer();
        Function<ResourceLocation, DimensionType> computeType = key -> server.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)key)).dimensionType();
        List<Pair> pairs = loaders.stream().map(loader -> Pair.of((Object)loader, loader.getLocation())).map(pair -> Pair.of((Object)((ChunkLoader)pair.getFirst()), (Object)Pair.of((Object)((ResourceLocation)((Pair)pair.getSecond()).getFirst()), (Object)Vec3.atCenterOf((Vec3i)((Vec3i)((Pair)pair.getSecond()).getSecond()))))).sorted(Comparator.comparingInt(p -> ((ResourceLocation)((Pair)p.getSecond()).getFirst()).equals((Object)level.dimension().location()) ? 0 : 1).thenComparingDouble(p -> ((Vec3)((Pair)p.getSecond()).getSecond()).scale(DimensionType.getTeleportationScale((DimensionType)((DimensionType)typeCache.computeIfAbsent((ResourceLocation)((Pair)p.getSecond()).getFirst(), computeType)), (DimensionType)level.dimensionType())).distanceToSqr(location))).limit(limit).toList();
        chat.accept("", white);
        chat.accept("-+------<< Chunk Loader List >>------+-", white);
        chat.accept(pairs.size() + " out of " + loaders.size() + " nearest" + (activeOnly ? " active" : "") + (String)(mode != null ? " " + mode.getSerializedName() : "") + " loaders", blue);
        chat.accept("", white);
        for (Pair pair2 : pairs) {
            ChunkLoader loader2 = (ChunkLoader)pair2.getFirst();
            ResourceLocation dimension = (ResourceLocation)((Pair)pair2.getSecond()).getFirst();
            BlockPos pos = BlockPos.containing((Position)((Position)((Pair)pair2.getSecond()).getSecond()));
            chatRaw.accept((Component)ListLoadersCommand.text((String)(mode == null ? loader2.getLoaderMode().getSerializedName() + " - " : ""), white).append((Component)ListLoadersCommand.text(loader2.getLoaderType().getSerializedName() + " - ", orange)).append((Component)ListLoadersCommand.text(loader2.getForcedChunks().size() + " chunks", ListLoadersCommand.colorForCount(loader2.getForcedChunks().size()))));
            chatRaw.accept((Component)ListLoadersCommand.text("                    \u21b3 ", darkBlue).append((Component)ListLoadersCommand.createTpButton(level.dimension().location(), dimension, pos, darkBlue)));
            if (loader2 instanceof TrainChunkLoader) {
                TrainChunkLoader trainLoader = (TrainChunkLoader)loader2;
                for (int i = 0; i < trainLoader.carriageLoaders.size(); ++i) {
                    CarriageChunkLoader carriageLoader = trainLoader.carriageLoaders.get(i);
                    if (carriageLoader.getForcedChunks().isEmpty()) continue;
                    Pair<ResourceLocation, BlockPos> carriageLocation = carriageLoader.getLocation();
                    chatRaw.accept((Component)ListLoadersCommand.text("    Carriage " + (i + 1) + " - ", gray).append((Component)ListLoadersCommand.text(carriageLoader.getLoaderType().getSerializedName() + " - ", orange)).append((Component)ListLoadersCommand.text(carriageLoader.getForcedChunks().size() + " chunks", ListLoadersCommand.colorForCount(carriageLoader.getForcedChunks().size()))));
                    chatRaw.accept((Component)ListLoadersCommand.text("                    \u21b3 ", darkBlue).append((Component)ListLoadersCommand.createTpButton(level.dimension().location(), (ResourceLocation)carriageLocation.getFirst(), (BlockPos)carriageLocation.getSecond(), darkBlue)));
                }
                continue;
            }
            if (!(loader2 instanceof StationChunkLoader)) continue;
            StationChunkLoader stationLoader = (StationChunkLoader)loader2;
            for (StationChunkLoader.AttachedLoader attachment : stationLoader.attachments) {
                chatRaw.accept((Component)ListLoadersCommand.text("    ", gray).append((Component)ListLoadersCommand.text("Attached - ", gray)).append((Component)ListLoadersCommand.text(attachment.type().getSerializedName(), orange)));
                chatRaw.accept((Component)ListLoadersCommand.text("                    \u21b3 ", darkBlue).append((Component)ListLoadersCommand.createTpButton(level.dimension().location(), (ResourceLocation)stationLoader.getLocation().getFirst(), attachment.pos(), darkBlue)));
            }
        }
        chat.accept("-+--------------------------------+-", white);
    }

    private static int colorForCount(int count) {
        if (count == 0) {
            return ChatFormatting.DARK_GRAY.getColor();
        }
        if (count < 5) {
            return ChatFormatting.GRAY.getColor();
        }
        if (count < 10) {
            return ChatFormatting.YELLOW.getColor();
        }
        return ChatFormatting.RED.getColor();
    }

    private static String shortString(ResourceLocation location) {
        if (location.getNamespace().equals("minecraft")) {
            return location.getPath();
        }
        return location.toString();
    }

    private static MutableComponent text(String text, int color) {
        return Component.literal((String)text).withStyle(style -> style.withColor(color));
    }

    private static MutableComponent createTpButton(ResourceLocation origin, ResourceLocation dimension, BlockPos blockPos, int color) {
        String teleport = "/execute in " + dimension.toString() + " run tp @s " + blockPos.getX() + " " + blockPos.getY() + " " + blockPos.getZ();
        return Component.literal((String)("[" + blockPos.toShortString() + "]" + (String)(!origin.equals((Object)dimension) ? " in " + ListLoadersCommand.shortString(dimension) : ""))).withStyle(style -> style.withColor(color).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, teleport)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to teleport"))).withInsertion(teleport));
    }
}

