/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.functions;

import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class CropFunctions {
    public static boolean applyBonemeal(ItemStack itemstack, Level world, BlockPos pos, Player player) {
        BonemealableBlock bonemealableblock;
        BlockState blockstate = world.getBlockState(pos);
        if (blockstate.getBlock() instanceof BonemealableBlock && (bonemealableblock = (BonemealableBlock)blockstate.getBlock()).isValidBonemealTarget((LevelReader)world, pos, blockstate)) {
            if (world instanceof ServerLevel) {
                if (bonemealableblock.isBonemealSuccess(world, world.random, pos, blockstate)) {
                    bonemealableblock.performBonemeal((ServerLevel)world, world.random, pos, blockstate);
                }
                if (!player.isCreative()) {
                    itemstack.shrink(1);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean growCrop(Level level, Player player, BlockState blockState, BlockPos blockPos) {
        return CropFunctions.growCrop(level, player, blockState, blockPos, player.getItemInHand(InteractionHand.MAIN_HAND));
    }

    public static boolean growCrop(Level level, Player player, BlockState blockState, BlockPos blockPos, InteractionHand interactionHand) {
        return CropFunctions.growCrop(level, player, blockState, blockPos, player.getItemInHand(interactionHand));
    }

    public static boolean growCrop(Level level, Player player, BlockState blockState, BlockPos blockPos, ItemStack itemStack) {
        if (level.isClientSide) {
            return false;
        }
        Block block = blockState.getBlock();
        if (block instanceof BonemealableBlock) {
            BonemealableBlock igrowable = (BonemealableBlock)block;
            while (igrowable.isValidBonemealTarget((LevelReader)level, blockPos, blockState) && igrowable.isBonemealSuccess(level, level.random, blockPos, blockState)) {
                igrowable.performBonemeal((ServerLevel)level, level.random, blockPos, blockState);
                blockState = level.getBlockState(blockPos);
                itemStack.shrink(1);
                if (itemStack.getCount() != 0) continue;
                break;
            }
        } else {
            block1: for (Property property : Collections.unmodifiableCollection(blockState.getValues().keySet())) {
                int max;
                IntegerProperty prop;
                String name;
                if (!(property instanceof IntegerProperty) || !(name = (prop = (IntegerProperty)property).getName()).equals("age")) continue;
                Comparable cv = (Comparable)blockState.getValues().get(property);
                int value = Integer.parseUnsignedInt(cv.toString());
                if (value == (max = ((Integer)Collections.max(prop.getPossibleValues())).intValue())) {
                    return false;
                }
                while (value < max) {
                    level.setBlockAndUpdate(blockPos, (BlockState)level.getBlockState(blockPos).cycle(property));
                    if (!player.isCreative()) {
                        itemStack.shrink(1);
                        if (itemStack.getCount() == 0) continue block1;
                    }
                    ++value;
                    if (player.isCrouching()) continue;
                    continue block1;
                }
            }
        }
        level.levelEvent(2005, blockPos, 0);
        return true;
    }

    public static boolean growCactus(Level world, BlockPos pos) {
        int height = world.getHeight();
        for (int y = pos.getY(); y <= height; ++y) {
            BlockPos uppos = new BlockPos(pos.getX(), y, pos.getZ());
            Block block = world.getBlockState(uppos).getBlock();
            if (block == Blocks.CACTUS) continue;
            if (!block.equals(Blocks.AIR)) break;
            world.setBlockAndUpdate(uppos, Blocks.CACTUS.defaultBlockState());
            world.levelEvent(2005, uppos, 0);
            world.levelEvent(2005, uppos.above(), 0);
            return true;
        }
        return false;
    }

    public static boolean growSugarcane(Level world, BlockPos pos) {
        int height = world.getHeight();
        for (int y = pos.getY(); y <= height; ++y) {
            BlockPos uppos = new BlockPos(pos.getX(), y, pos.getZ());
            Block block = world.getBlockState(uppos).getBlock();
            if (block == Blocks.SUGAR_CANE) continue;
            if (!block.equals(Blocks.AIR)) break;
            world.setBlockAndUpdate(uppos, Blocks.SUGAR_CANE.defaultBlockState());
            world.levelEvent(2005, uppos, 0);
            world.levelEvent(2005, uppos.above(), 0);
            return true;
        }
        return false;
    }

    public static boolean growVine(Level world, BlockPos pos) {
        for (int y = pos.getY(); y > 0; --y) {
            BlockPos downpos = new BlockPos(pos.getX(), y, pos.getZ());
            Block block = world.getBlockState(downpos).getBlock();
            if (block == Blocks.VINE) continue;
            if (!block.equals(Blocks.AIR)) break;
            world.setBlockAndUpdate(downpos, world.getBlockState(pos));
            world.levelEvent(2005, downpos, 0);
            world.levelEvent(2005, downpos.below(), 0);
            return true;
        }
        return false;
    }
}

