/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.PushReaction;
import xaero.map.MapWriter;
import xaero.map.WorldMap;
import xaero.map.misc.CachedFunction;

public class CaveStartCalculator {
    private final BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
    private final CachedFunction<StateHolder<?, ?>, Boolean> transparentCache = new CachedFunction<StateHolder, Boolean>(state -> mapWriter.shouldOverlay((StateHolder<?, ?>)state));

    public CaveStartCalculator(MapWriter mapWriter) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCaving(double playerX, double playerY, double playerZ, Level world) {
        if (WorldMap.settings.autoCaveMode == 0) {
            return Integer.MAX_VALUE;
        }
        int worldBottomY = world.getMinBuildHeight();
        int worldTopY = world.getMaxBuildHeight() - 1;
        int y = (int)playerY + 1;
        int defaultCaveStart = y + 3;
        int defaultResult = Integer.MAX_VALUE;
        if (y > worldTopY || y < worldBottomY) {
            return defaultResult;
        }
        int x = Mth.floor((double)playerX);
        int z = Mth.floor((double)playerZ);
        int roofRadius = WorldMap.settings.autoCaveMode < 0 ? 1 : WorldMap.settings.autoCaveMode - 1;
        int roofDiameter = 1 + roofRadius * 2;
        int startX = x - roofRadius;
        int startZ = z - roofRadius;
        boolean ignoringHeightmaps = WorldMap.settings.ignoreHeightmaps;
        int bottom = y;
        int top = Integer.MAX_VALUE;
        LevelChunk prevBChunk = null;
        int potentialResult = defaultCaveStart;
        for (int o = 0; o < roofDiameter; ++o) {
            block1: for (int p = 0; p < roofDiameter; ++p) {
                int currentX = startX + o;
                int currentZ = startZ + p;
                this.mutableBlockPos.set(currentX, y, currentZ);
                LevelChunk bchunk = world.getChunk(currentX >> 4, currentZ >> 4);
                if (bchunk == null) {
                    return defaultResult;
                }
                int skyLight = world.getBrightness(LightLayer.SKY, (BlockPos)this.mutableBlockPos);
                if (!ignoringHeightmaps) {
                    if (skyLight >= 15) return defaultResult;
                    int insideX = currentX & 0xF;
                    int insideZ = currentZ & 0xF;
                    top = bchunk.getHeight(Heightmap.Types.WORLD_SURFACE, insideX, insideZ);
                } else if (bchunk != prevBChunk) {
                    LevelChunkSection[] sections = bchunk.getSections();
                    if (sections.length == 0) {
                        return defaultResult;
                    }
                    int playerSection = y - worldBottomY >> 4;
                    boolean foundSomething = false;
                    for (int i = playerSection; i < sections.length; ++i) {
                        LevelChunkSection searchedSection = sections[i];
                        if (searchedSection.hasOnlyAir()) continue;
                        if (!foundSomething) {
                            bottom = Math.max(bottom, worldBottomY + (i << 4));
                            foundSomething = true;
                        }
                        top = worldBottomY + (i << 4) + 15;
                    }
                    if (!foundSomething) {
                        return defaultResult;
                    }
                    prevBChunk = bchunk;
                }
                if (top < worldBottomY) {
                    return defaultResult;
                }
                if (top > worldTopY) {
                    top = worldTopY;
                }
                for (int i = bottom; i <= top; ++i) {
                    this.mutableBlockPos.setY(i);
                    BlockState state = world.getBlockState((BlockPos)this.mutableBlockPos);
                    if (state.isAir() || state.getPistonPushReaction() == PushReaction.DESTROY || state.getBlock() instanceof LiquidBlock || state.is(BlockTags.LEAVES) || this.transparentCache.apply((StateHolder<?, ?>)state).booleanValue() || state.getBlock() == Blocks.BARRIER) continue;
                    if (o != p || o != roofRadius) continue block1;
                    potentialResult = Math.min(i, defaultCaveStart);
                    continue block1;
                }
                return defaultResult;
            }
        }
        return potentialResult;
    }
}

