/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.weapon;

import com.mojang.math.Axis;
import immersive_aircraft.Main;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.weapon.Weapon;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RotationalManager {
    private final Weapon weapon;
    float yaw = 0.0f;
    float pitch = 0.0f;
    float roll = 0.0f;
    float lastYaw = 0.0f;
    float lastPitch = 0.0f;
    float lastRoll = 0.0f;

    public RotationalManager(Weapon weapon) {
        this.weapon = weapon;
    }

    private float turn(float diff) {
        if ((double)diff > Math.PI) {
            diff -= (float)Math.PI * 2;
        } else if ((double)diff < -Math.PI) {
            diff += (float)Math.PI * 2;
        }
        return diff;
    }

    public float getPitch(float tickDelta) {
        float diff = this.turn(this.pitch - this.lastPitch);
        return this.lastPitch + diff * tickDelta;
    }

    public float getYaw(float tickDelta) {
        float diff = this.turn(this.yaw - this.lastYaw);
        return this.lastYaw + diff * tickDelta;
    }

    public float getRoll(float tickDelta) {
        float diff = this.turn(this.roll - this.lastRoll);
        return this.lastRoll + diff * tickDelta;
    }

    public void tick() {
        this.lastYaw = this.yaw;
        this.lastPitch = this.pitch;
        this.lastRoll = this.roll;
    }

    public Matrix3f getCamera(VehicleEntity vehicle, Entity pilot) {
        Matrix3f camera = new Matrix3f();
        if (vehicle.adaptPlayerRotation && Main.firstPersonGetter.isFirstPerson()) {
            camera.rotate((Quaternionfc)Axis.ZP.rotationDegrees(vehicle.getRoll()));
            camera.rotate((Quaternionfc)Axis.XP.rotationDegrees(vehicle.getXRot()));
        }
        camera.rotate((Quaternionfc)Axis.XP.rotationDegrees(pilot.getXRot()));
        camera.rotate((Quaternionfc)Axis.YP.rotationDegrees(pilot.getYRot() + 180.0f));
        return camera;
    }

    public void pointTo(VehicleEntity vehicle) {
        this.pointTo(vehicle, new Vector3f(0.0f, 0.0f, -1.0f));
    }

    public void pointTo(VehicleEntity vehicle, Vector3f normal) {
        this.screenToGlobal(vehicle, normal);
        Matrix3f vehicleTransform = new Matrix3f((Matrix3fc)vehicle.getVehicleNormalTransform());
        vehicleTransform.invert();
        normal.mul((Matrix3fc)vehicleTransform);
        Matrix3f weaponTransform = new Matrix3f((Matrix4fc)this.weapon.getMount().transform());
        weaponTransform.invert();
        normal.mul((Matrix3fc)weaponTransform);
        this.yaw = (float)(-Math.atan2(normal.x(), normal.z()));
        this.pitch = (float)(-Math.atan2(normal.y(), Math.sqrt(normal.x() * normal.x() + normal.z() * normal.z())));
    }

    public Vector3f screenToGlobal(VehicleEntity vehicle) {
        return this.screenToGlobal(vehicle, new Vector3f(0.0f, 0.0f, -1.0f));
    }

    public Vector3f screenToGlobal(VehicleEntity vehicle, Vector3f normal) {
        Entity pilot = vehicle.getGunner(this.weapon.getGunnerOffset());
        if (pilot != null) {
            Matrix3f camera = this.getCamera(vehicle, pilot);
            camera.invert();
            normal.mul((Matrix3fc)camera);
        }
        return normal;
    }
}

