/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import biomesoplenty.api.block.BOPBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class WillowLeavesBlock
extends LeavesBlock {
    public static final BooleanProperty MOSSY = BooleanProperty.create((String)"mossy");

    public WillowLeavesBlock(BlockBehaviour.Properties p_273704_) {
        super(p_273704_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)MOSSY, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState updateShape(BlockState p_54440_, Direction p_54441_, BlockState p_54442_, LevelAccessor p_54443_, BlockPos p_54444_, BlockPos p_54445_) {
        int i;
        if (((Boolean)p_54440_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_54443_.scheduleTick(p_54444_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)p_54443_));
        }
        if ((i = WillowLeavesBlock.getDistanceAt(p_54442_) + 1) != 1 || (Integer)p_54440_.getValue((Property)DISTANCE) != i) {
            p_54443_.scheduleTick(p_54444_, (Block)this, 1);
        }
        BlockState below = p_54443_.getBlockState(p_54444_.below());
        return (BlockState)p_54440_.setValue((Property)MOSSY, (Comparable)Boolean.valueOf(WillowLeavesBlock.isMoss(below)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_54424_) {
        FluidState fluidstate = p_54424_.getLevel().getFluidState(p_54424_.getClickedPos());
        BlockState blockstate = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        BlockState blockstateBelow = p_54424_.getLevel().getBlockState(p_54424_.getClickedPos().below());
        return WillowLeavesBlock.updateDistance((BlockState)blockstate.setValue((Property)MOSSY, (Comparable)Boolean.valueOf(WillowLeavesBlock.isMoss(blockstateBelow))), (LevelAccessor)p_54424_.getLevel(), p_54424_.getClickedPos());
    }

    private static BlockState updateDistance(BlockState p_54436_, LevelAccessor p_54437_, BlockPos p_54438_) {
        int i = 7;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockpos$mutableblockpos.setWithOffset((Vec3i)p_54438_, direction);
            i = Math.min(i, WillowLeavesBlock.getDistanceAt(p_54437_.getBlockState((BlockPos)blockpos$mutableblockpos)) + 1);
            if (i == 1) break;
        }
        return (BlockState)p_54436_.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceAt(BlockState p_54464_) {
        return WillowLeavesBlock.getOptionalDistanceAt((BlockState)p_54464_).orElse(7);
    }

    private static boolean isMoss(BlockState p_154649_) {
        return p_154649_.getBlock() == BOPBlocks.SPANISH_MOSS || p_154649_.getBlock() == BOPBlocks.SPANISH_MOSS_PLANT;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_56651_) {
        p_56651_.add(new Property[]{DISTANCE, PERSISTENT, WATERLOGGED, MOSSY});
    }
}

