/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.mixin.shader;

import com.koteinik.chunksfadein.Logger;
import com.koteinik.chunksfadein.core.FadeShaderInterface;
import com.koteinik.chunksfadein.extensions.ChunkShaderInterfaceExt;
import com.koteinik.chunksfadein.hooks.CompatibilityHook;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlMutableBuffer;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderOptions;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.DefaultShaderInterface;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ShaderBindingContext;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DefaultShaderInterface.class}, remap=false)
public abstract class ChunkShaderInterfaceMixin
implements ChunkShaderInterfaceExt {
    private FadeShaderInterface fadeInterface;
    private static boolean warned = false;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void modifyConstructor(ShaderBindingContext context, ChunkShaderOptions options, CallbackInfo ci) {
        if (CompatibilityHook.isIrisShaderPackInUse()) {
            return;
        }
        this.fadeInterface = new FadeShaderInterface(context);
    }

    @Override
    public void setFadeDatas(GlMutableBuffer buffer) {
        if (this.fadeInterface == null) {
            if (CompatibilityHook.isIrisShaderPackInUse() && !warned) {
                Logger.warn("Shader pack is in use, but Sodium's shader interface is used. Something went really wrong!");
                warned = true;
            }
            return;
        }
        this.fadeInterface.setFadeDatas(buffer);
    }
}

