/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.mixin.chunk;

import com.koteinik.chunksfadein.MathUtils;
import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.AnimationType;
import com.koteinik.chunksfadein.core.DataBuffer;
import com.koteinik.chunksfadein.extensions.RenderSectionExt;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={RenderSection.class}, remap=false)
public class RenderSectionMixin
implements RenderSectionExt {
    private static final Vector3f UP = new Vector3f(0.0f, 1.0f, 0.0f);
    @Shadow
    @Final
    private RenderRegion region;
    @Shadow
    @Final
    private int chunkX;
    @Shadow
    @Final
    private int chunkY;
    @Shadow
    @Final
    private int chunkZ;
    private long lastFrameTime = 0L;
    private boolean hasRenderedBefore;
    private float fadeCoeff = 0.0f;
    private float animationProgress = 0.0f;
    private final float[] offset = new float[3];

    @Override
    public boolean hasRenderedBefore() {
        return this.hasRenderedBefore;
    }

    @Override
    public void setRenderedBefore() {
        this.hasRenderedBefore = true;
    }

    @Override
    public boolean incrementFadeCoeff(long delta, int sectionIndex, DataBuffer buffer) {
        if (this.fadeCoeff == 1.0f) {
            return false;
        }
        this.fadeCoeff += (float)delta * Config.fadeChangePerMs;
        if (this.fadeCoeff > 1.0f) {
            this.fadeCoeff = 1.0f;
        }
        if (!this.hasRenderedBefore() && !Config.fadeNearPlayer && this.isNearPlayer()) {
            this.fadeCoeff = 1.0f;
        }
        buffer.put(sectionIndex, 3, this.fadeCoeff);
        return true;
    }

    @Override
    public boolean incrementAnimationOffset(long delta, int sectionIndex, DataBuffer buffer) {
        if (this.animationProgress == 1.0f) {
            return false;
        }
        this.animationProgress += (float)delta * Config.animationChangePerMs;
        if (this.animationProgress > 1.0f) {
            this.animationProgress = 1.0f;
        }
        if (!this.hasRenderedBefore() && !Config.animateNearPlayer && this.isNearPlayer()) {
            this.animationProgress = 1.0f;
        }
        float progress = Config.animationCurve.calculate(Float.valueOf(this.animationProgress)).floatValue();
        if (Config.animationType == AnimationType.JAGGED) {
            this.offset[1] = MathUtils.lerp(-Config.animationFactor * 16.0f, 0.0f, progress);
        } else if (Config.animationType == AnimationType.DISPLACEMENT || Config.animationType == AnimationType.SCALE) {
            this.offset[1] = MathUtils.lerp(Config.animationFactor, 0.0f, progress);
        } else if (Config.animationAngle == 0.0f) {
            this.offset[1] = MathUtils.lerp(Config.animationOffset, 0.0f, progress);
        } else {
            Vec3 thisPos = new Vec3((double)(this.chunkX * 16 + 8), 0.0, (double)(this.chunkZ * 16 + 8));
            Vec3 camPos = RenderSectionMixin.getCameraPosition();
            camPos = new Vec3(camPos.x, 0.0, camPos.z);
            Vector3f direction = camPos.toVector3f().sub((Vector3fc)thisPos.toVector3f()).normalize();
            Vector3f axis = new Vector3f((Vector3fc)direction).cross((Vector3fc)UP);
            direction.rotateAxis((float)Math.toRadians(90.0f - Config.animationAngle), axis.x, axis.y, axis.z).mul(Config.animationOffset).lerp((Vector3fc)new Vector3f(), progress);
            if (Config.animationOffset > 0.0f) {
                direction.rotateY((float)Math.PI);
            }
            this.offset[0] = direction.x;
            this.offset[1] = direction.y;
            this.offset[2] = direction.z;
        }
        for (int i = 0; i < 3; ++i) {
            buffer.put(sectionIndex, i, this.offset[i]);
        }
        return true;
    }

    @Override
    public long calculateAndGetDelta() {
        long currentFrameTime = System.currentTimeMillis();
        long delta = this.lastFrameTime == 0L ? 0L : currentFrameTime - this.lastFrameTime;
        this.lastFrameTime = currentFrameTime;
        return delta;
    }

    @Override
    public float[] getAnimationOffset() {
        return this.offset;
    }

    @Override
    public float getFadeCoeff() {
        return this.fadeCoeff;
    }

    private boolean isNearPlayer() {
        SectionPos chunkPos = SectionPos.of((Position)RenderSectionMixin.getCameraPosition());
        int camChunkX = chunkPos.getX();
        int camChunkZ = chunkPos.getZ();
        return MathUtils.chunkInRange(this.chunkX, this.chunkZ, camChunkX, camChunkZ, 1);
    }

    private static Vec3 getCameraPosition() {
        Minecraft client = Minecraft.getInstance();
        Entity camera = client.cameraEntity;
        if (camera == null) {
            return new Vec3(0.0, 0.0, 0.0);
        }
        return camera.position();
    }
}

