/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.gui.sodium;

import com.google.common.collect.ImmutableList;
import com.koteinik.chunksfadein.MathUtils;
import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.AnimationType;
import com.koteinik.chunksfadein.core.Curve;
import com.koteinik.chunksfadein.core.FadeType;
import com.koteinik.chunksfadein.core.TranslatableEnum;
import com.koteinik.chunksfadein.gui.GuiUtils;
import com.koteinik.chunksfadein.gui.SettingsScreen;
import com.koteinik.chunksfadein.gui.sodium.CFIOptionsStorage;
import com.koteinik.chunksfadein.hooks.CompatibilityHook;
import com.koteinik.chunksfadein.platform.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.OptionGroup;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpact;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpl;
import net.caffeinemc.mods.sodium.client.gui.options.OptionPage;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlValueFormatter;
import net.caffeinemc.mods.sodium.client.gui.options.control.CyclingControl;
import net.caffeinemc.mods.sodium.client.gui.options.control.SliderControl;
import net.caffeinemc.mods.sodium.client.gui.options.control.TickBoxControl;
import net.caffeinemc.mods.sodium.client.gui.options.storage.OptionStorage;
import net.minecraft.network.chat.Component;

public class CFISodiumPage
extends OptionPage {
    private static final String SODIUM_PAGE_NAME = "settings.chunksfadein.sodium_page_name";
    private static final CFIOptionsStorage cfiStorage = new CFIOptionsStorage();

    public CFISodiumPage() {
        super((Component)Component.translatable((String)SODIUM_PAGE_NAME), ImmutableList.copyOf(CFISodiumPage.makeOptions()));
    }

    private static List<OptionGroup> makeOptions() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        boolean forceEnableTab = !Services.PLATFORM.isForge() && !CompatibilityHook.isModMenuLoaded;
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)cfiStorage).setName((Component)Component.translatable((String)"settings.chunksfadein.mod_enabled")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.mod_enabled")).setControl(TickBoxControl::new).setBinding((c, v) -> cfiStorage.setBooleanDirty("mod-enabled", (boolean)v), c -> Config.isModEnabled).setImpact(OptionImpact.LOW).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)cfiStorage).setName((Component)Component.translatable((String)"settings.chunksfadein.update_notifier_enabled")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.update_notifier_enabled")).setControl(TickBoxControl::new).setBinding((c, v) -> Config.setBoolean("update-notifier-enabled", v), c -> Config.isUpdateNotifierEnabled).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)cfiStorage).setName((Component)Component.translatable((String)"settings.chunksfadein.mod_tab_enabled")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.mod_tab_enabled").append((Component)(forceEnableTab ? Component.literal((String)"\n").append((Component)SettingsScreen.MOD_TAB_TOOLTIP) : Component.empty()))).setControl(TickBoxControl::new).setEnabled(() -> !forceEnableTab).setBinding((c, v) -> Config.setBoolean("show-mod-tab-in-settings", v), c -> forceEnableTab ? true : Config.showModTabInSettings).build()).build());
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)cfiStorage).setName((Component)Component.translatable((String)"settings.chunksfadein.fade_enabled")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.fade_enabled")).setControl(TickBoxControl::new).setBinding((c, v) -> cfiStorage.setBooleanDirty("fade-enabled", (boolean)v), c -> Config.isFadeEnabled).setImpact(OptionImpact.LOW).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)cfiStorage).setName((Component)Component.translatable((String)"settings.chunksfadein.fade_near_player")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.fade_near_player")).setControl(TickBoxControl::new).setBinding((c, v) -> Config.setBoolean("fade-near-player", v), c -> Config.fadeNearPlayer).build()).add((Option)OptionImpl.createBuilder(FadeType.class, (OptionStorage)cfiStorage).setName((Component)Component.translatable((String)"settings.chunksfadein.fade_type")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.fade_type")).setControl(o -> new CyclingControl((Option)o, FadeType.class, CFISodiumPage.translations(FadeType.class))).setBinding((c, v) -> cfiStorage.setIntegerDirty("fade-type", v.ordinal()), c -> Config.fadeType).build()).add((Option)OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)cfiStorage).setName((Component)Component.translatable((String)"settings.chunksfadein.fade_time")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.fade_time")).setControl(o -> new SliderControl((Option)o, MathUtils.roundToInt(1.0), MathUtils.roundToInt(1000.0), 1, CFISodiumPage.scaled(100, (Component)SettingsScreen.UNITS_SECONDS))).setBinding((c, v) -> Config.setDouble("fade-time", (double)v.intValue() / 100.0), c -> MathUtils.roundToInt(Config.secondsFromFadeChange() * 100.0f)).build()).build());
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)cfiStorage).setName((Component)Component.translatable((String)"settings.chunksfadein.animation_enabled")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.animation_enabled")).setControl(TickBoxControl::new).setBinding((c, v) -> cfiStorage.setBooleanDirty("animation-enabled", (boolean)v), c -> Config.isAnimationEnabled).setImpact(OptionImpact.LOW).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)cfiStorage).setName((Component)Component.translatable((String)"settings.chunksfadein.animate_near_player")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.animate_near_player")).setControl(TickBoxControl::new).setBinding((c, v) -> Config.setBoolean("animate-near-player", v), c -> Config.animateNearPlayer).build()).add((Option)OptionImpl.createBuilder(Curve.class, (OptionStorage)cfiStorage).setName((Component)Component.translatable((String)"settings.chunksfadein.animation_curve")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.animation_curve")).setControl(o -> new CyclingControl((Option)o, Curve.class, CFISodiumPage.translations(Curve.class))).setBinding((c, v) -> cfiStorage.setIntegerDirty("animation-curve", v.ordinal()), c -> Config.animationCurve).build()).add((Option)OptionImpl.createBuilder(AnimationType.class, (OptionStorage)cfiStorage).setName((Component)Component.translatable((String)"settings.chunksfadein.animation_type")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.animation_type")).setControl(o -> new CyclingControl((Option)o, AnimationType.class, CFISodiumPage.translations(AnimationType.class))).setBinding((c, v) -> cfiStorage.setIntegerDirty("animation-type", v.ordinal()), c -> Config.animationType).build()).add((Option)OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)cfiStorage).setName((Component)Component.translatable((String)"settings.chunksfadein.animation_time")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.animation_time")).setControl(o -> new SliderControl((Option)o, MathUtils.roundToInt(1.0), MathUtils.roundToInt(1000.0), 1, CFISodiumPage.scaled(100, (Component)SettingsScreen.UNITS_SECONDS))).setBinding((c, v) -> Config.setDouble("animation-time", (double)v.intValue() / 100.0), c -> MathUtils.roundToInt(Config.secondsFromAnimationChange() * 100.0)).build()).add((Option)OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)cfiStorage).setName((Component)Component.translatable((String)"settings.chunksfadein.animation_start")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.animation_start")).setControl(o -> new SliderControl((Option)o, MathUtils.roundToInt(-12800.0), MathUtils.roundToInt(12800.0), 1, CFISodiumPage.scaled(100, (Component)SettingsScreen.UNITS_BLOCKS))).setBinding((c, v) -> Config.setDouble("animation-offset", (double)v.intValue() / 100.0), c -> MathUtils.roundToInt(Config.animationOffset * 100.0f)).build()).add((Option)OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)cfiStorage).setName((Component)Component.translatable((String)"settings.chunksfadein.animation_angle")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.animation_angle")).setControl(o -> new SliderControl((Option)o, MathUtils.roundToInt(0.0), MathUtils.roundToInt(90.0), 1, CFISodiumPage.number((Component)SettingsScreen.UNITS_DEGREES))).setBinding((c, v) -> Config.setDouble("animation-angle", (double)v), c -> MathUtils.roundToInt(Config.animationAngle)).build()).add((Option)OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)cfiStorage).setName((Component)Component.translatable((String)"settings.chunksfadein.animation_factor")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.animation_factor")).setControl(o -> new SliderControl((Option)o, MathUtils.roundToInt(1.0), MathUtils.roundToInt(100.0), 1, CFISodiumPage.scaled(100))).setBinding((c, v) -> Config.setDouble("animation-factor", (double)v.intValue() / 100.0), c -> MathUtils.roundToInt(Config.animationFactor * 100.0f)).build()).build());
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)cfiStorage).setName((Component)Component.translatable((String)"settings.chunksfadein.world_curvature_enabled")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.world_curvature_enabled")).setControl(TickBoxControl::new).setBinding((c, v) -> cfiStorage.setBooleanDirty("world-curvature-enabled", (boolean)v), c -> Config.isCurvatureEnabled).setImpact(OptionImpact.LOW).build()).add((Option)OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)cfiStorage).setName((Component)Component.translatable((String)"settings.chunksfadein.world_curvature")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.world_curvature")).setControl(o -> new SliderControl((Option)o, 0, 15, 1, v -> Component.literal((String)String.valueOf(SettingsScreen.CURVATURE_VALUES[v])))).setBinding((c, v) -> cfiStorage.setIntegerDirty("world-curvature", SettingsScreen.CURVATURE_VALUES[v]), c -> SettingsScreen.curvatureValueIdx(Config.worldCurvature)).build()).build());
        return groups;
    }

    private static ControlValueFormatter scaled(int scale) {
        return CFISodiumPage.scaled(scale, (Component)Component.empty());
    }

    private static ControlValueFormatter scaled(int scale, Component units) {
        return v -> Component.literal((String)String.valueOf((double)v / (double)scale)).append(units);
    }

    private static ControlValueFormatter number(Component units) {
        return v -> Component.literal((String)String.valueOf(v)).append(units);
    }

    private static <T extends Enum<T>> Component[] translations(Class<T> clazz) {
        return (Component[])Arrays.stream((Enum[])clazz.getEnumConstants()).map(rec$ -> ((TranslatableEnum)rec$).getTranslation()).toArray(Component[]::new);
    }
}

