/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.koteinik.chunksfadein.Logger;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;

public class NetworkUtils {
    public static JsonElement executeGet(String rawUrl, Map<String, String> headers, Map<String, String> params) {
        try {
            String inputLine;
            Object paramsStr = "";
            int i = 0;
            for (Map.Entry<String, String> entry : params.entrySet()) {
                paramsStr = i == 0 ? (String)paramsStr + "?" : (String)paramsStr + "&";
                paramsStr = (String)paramsStr + NetworkUtils.encode(entry.getKey());
                paramsStr = (String)paramsStr + "=";
                paramsStr = (String)paramsStr + NetworkUtils.encode(entry.getValue());
                ++i;
            }
            URL url = URL.of(URI.create(rawUrl + (String)paramsStr), null);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("Content-Type", "application/json");
            headers.forEach((key, value) -> con.setRequestProperty((String)key, (String)value));
            con.setConnectTimeout(10000);
            con.setReadTimeout(5000);
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            Object body = "";
            while ((inputLine = in.readLine()) != null) {
                body = (String)body + inputLine;
            }
            in.close();
            con.disconnect();
            return JsonParser.parseString((String)body);
        }
        catch (Exception e) {
            Logger.warn("Failed to execute GET http request on '" + rawUrl + "'! Cause: " + e.getMessage());
            return null;
        }
    }

    private static String encode(String str) throws UnsupportedEncodingException {
        return URLEncoder.encode(str, "UTF-8");
    }
}

