/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.registry;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import plus.dragons.createdragonsplus.common.registry.CDPItems;
import plus.dragons.createdragonsplus.config.CDPConfig;

public class CDPLoots {

    @EventBusSubscriber
    public static class TableInjections {
        public static final Object2IntMap<ResourceLocation> BLAZE_UPGRADE_SMITHING_TEMPLATE = (Object2IntMap)Util.make((Object)new Object2IntOpenHashMap(), map -> {
            map.put((Object)BuiltInLootTables.BASTION_TREASURE.location(), 1);
            map.put((Object)BuiltInLootTables.BASTION_OTHER.location(), 10);
            map.put((Object)BuiltInLootTables.BASTION_BRIDGE.location(), 10);
            map.put((Object)BuiltInLootTables.BASTION_HOGLIN_STABLE.location(), 10);
            map.put((Object)BuiltInLootTables.NETHER_BRIDGE.location(), 10);
        });

        @SubscribeEvent
        public static void onLootTableLoad(LootTableLoadEvent event) {
            ResourceLocation name = event.getName();
            LootTable table = event.getTable();
            if (CDPConfig.features().blazeUpgradeSmithingTemplate.get().booleanValue() && BLAZE_UPGRADE_SMITHING_TEMPLATE.containsKey((Object)name)) {
                TableInjections.addBlazeUpgradeSmithingTemplate(table, BLAZE_UPGRADE_SMITHING_TEMPLATE.getInt((Object)name));
            }
        }

        private static void addBlazeUpgradeSmithingTemplate(LootTable table, int totalWeight) {
            LootPool.Builder pool = LootPool.lootPool().name(CDPItems.BLAZE_UPGRADE_SMITHING_TEMPLATE.getRegisteredName()).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(CDPItems.BLAZE_UPGRADE_SMITHING_TEMPLATE).setWeight(1));
            if (totalWeight > 1) {
                pool.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(totalWeight - 1));
            }
            table.addPool(pool.build());
        }
    }
}

