/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.processing.blaze;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerRenderer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.client.renderer.blockentity.PartialModelBlockEntityRenderer;
import plus.dragons.createdragonsplus.common.processing.blaze.BlazeBlockEntity;
import plus.dragons.createdragonsplus.util.CodeReference;

@CodeReference(value={BlazeBurnerRenderer.class}, source={"create"}, license={"mit"})
public class BlazeBlockRenderer<T extends BlazeBlockEntity>
extends SafeBlockEntityRenderer<T>
implements PartialModelBlockEntityRenderer {
    public BlazeBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        BlazeBurnerBlock.HeatLevel heatLevel = ((BlazeBlockEntity)((Object)blockEntity)).getHeatLevelFromBlock();
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        Level level = blockEntity.getLevel();
        assert (level != null);
        float renderTime = AnimationTickHolder.getRenderTime((LevelAccessor)level);
        BlockState blockState = blockEntity.getBlockState();
        float animation = ((BlazeBlockEntity)((Object)blockEntity)).headAnimation.getValue(partialTicks) * 0.175f;
        float horizontalAngle = AngleHelper.rad((double)((BlazeBlockEntity)((Object)blockEntity)).headAngle.getValue(partialTicks));
        boolean active = animation > 0.125f;
        int seed = blockEntity.hashCode();
        PartialModel blazeModel = BlazeBurnerRenderer.getBlazeModel((BlazeBurnerBlock.HeatLevel)heatLevel, (boolean)active);
        PartialModel hatModel = ((BlazeBlockEntity)((Object)blockEntity)).getHatModel(heatLevel);
        PartialModel gogglesModel = ((BlazeBlockEntity)((Object)blockEntity)).getGogglesModel(heatLevel);
        this.renderBlaze(blockState, heatLevel, renderTime, poseStack, null, bufferSource, light, overlay, seed, animation, horizontalAngle, active && heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING), blazeModel, hatModel, gogglesModel);
    }

    protected void renderGoggles(BlockState blockState, BlazeBurnerBlock.HeatLevel heatLevel, float renderTime, PoseStack poseStack, @Nullable PoseStack transformStack, MultiBufferSource bufferSource, int light, int overlay, int seed, float animation, float horizontalAngle, float headY, PartialModel blazeModel, PartialModel gogglesModel) {
        SuperByteBuffer gogglesBuffer = CachedBuffers.partial((PartialModel)gogglesModel, (BlockState)blockState);
        if (transformStack != null) {
            gogglesBuffer.transform(transformStack);
        }
        gogglesBuffer.translate(0.0f, headY + 0.5f, 0.0f);
        RenderType renderType = this.getRenderType(blockState, gogglesModel);
        BlazeBlockRenderer.draw(gogglesBuffer, horizontalAngle, poseStack, bufferSource.getBuffer(renderType));
    }

    protected void renderHat(BlockState blockState, BlazeBurnerBlock.HeatLevel heatLevel, float renderTime, PoseStack poseStack, @Nullable PoseStack transformStack, MultiBufferSource bufferSource, int light, int overlay, int seed, float animation, float horizontalAngle, float headY, PartialModel blazeModel, PartialModel hatModel) {
        SuperByteBuffer hatBuffer = CachedBuffers.partial((PartialModel)hatModel, (BlockState)blockState);
        if (transformStack != null) {
            hatBuffer.transform(transformStack);
        }
        hatBuffer.translate(0.0f, headY + 0.75f, 0.0f);
        RenderType renderType = this.getRenderType(blockState, hatModel);
        BlazeBlockRenderer.drawCentered(hatBuffer, horizontalAngle + (float)Math.PI, poseStack, bufferSource.getBuffer(renderType));
    }

    public void renderBlaze(BlockState blockState, BlazeBurnerBlock.HeatLevel heatLevel, float renderTime, PoseStack poseStack, @Nullable PoseStack transformStack, MultiBufferSource bufferSource, int light, int overlay, int seed, float animation, float horizontalAngle, boolean active, PartialModel blazeModel, @Nullable PartialModel hatModel, @Nullable PartialModel gogglesModel) {
        float seededRenderTime = renderTime + (float)(seed % 13) * 16.0f;
        float offsetScale = heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) ? 64.0f : 16.0f;
        float offset = Mth.sin((float)(seededRenderTime / 16.0f % ((float)Math.PI * 2))) / offsetScale;
        float rodsOffset1 = Mth.sin((float)((seededRenderTime / 16.0f + (float)Math.PI) % ((float)Math.PI * 2))) / offsetScale;
        float rodsOffset2 = Mth.sin((float)((seededRenderTime / 16.0f + 1.5707964f) % ((float)Math.PI * 2))) / offsetScale;
        float headY = offset - animation * 0.75f;
        poseStack.pushPose();
        SuperByteBuffer blazeBuffer = CachedBuffers.partial((PartialModel)blazeModel, (BlockState)blockState);
        if (transformStack != null) {
            blazeBuffer.transform(transformStack);
        }
        blazeBuffer.translate(0.0f, headY, 0.0f);
        BlazeBlockRenderer.draw(blazeBuffer, horizontalAngle, poseStack, bufferSource.getBuffer(RenderType.solid()));
        if (gogglesModel != null) {
            this.renderGoggles(blockState, heatLevel, renderTime, poseStack, transformStack, bufferSource, light, overlay, seed, animation, horizontalAngle, headY, blazeModel, gogglesModel);
        }
        if (hatModel != null) {
            this.renderHat(blockState, heatLevel, renderTime, poseStack, transformStack, bufferSource, light, overlay, seed, animation, horizontalAngle, headY, blazeModel, hatModel);
        }
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            PartialModel rodsModel = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS : AllPartialModels.BLAZE_BURNER_RODS;
            PartialModel rodsModel2 = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS_2 : AllPartialModels.BLAZE_BURNER_RODS_2;
            SuperByteBuffer rodsBuffer = CachedBuffers.partial((PartialModel)rodsModel, (BlockState)blockState);
            if (transformStack != null) {
                rodsBuffer.transform(transformStack);
            }
            ((SuperByteBuffer)rodsBuffer.translate(0.0f, rodsOffset1 + animation + 0.125f, 0.0f)).light(0xF000F0).renderInto(poseStack, bufferSource.getBuffer(RenderType.solid()));
            SuperByteBuffer rodsBuffer2 = CachedBuffers.partial((PartialModel)rodsModel2, (BlockState)blockState);
            if (transformStack != null) {
                rodsBuffer2.transform(transformStack);
            }
            ((SuperByteBuffer)rodsBuffer2.translate(0.0f, rodsOffset2 + animation - 0.1875f, 0.0f)).light(0xF000F0).renderInto(poseStack, bufferSource.getBuffer(RenderType.solid()));
        }
        if (active) {
            SpriteShiftEntry spriteShift = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllSpriteShifts.SUPER_BURNER_FLAME : AllSpriteShifts.BURNER_FLAME;
            float spriteWidth = spriteShift.getTarget().getU1() - spriteShift.getTarget().getU0();
            float spriteHeight = spriteShift.getTarget().getV1() - spriteShift.getTarget().getV0();
            float speed = 0.03125f + 0.015625f * (float)heatLevel.ordinal();
            float uScroll = speed * renderTime / 2.0f;
            uScroll -= (float)Mth.floor((float)uScroll);
            uScroll *= spriteWidth / 2.0f;
            float vScroll = speed * renderTime;
            vScroll -= (float)Mth.floor((float)vScroll);
            vScroll *= spriteHeight / 2.0f;
            SuperByteBuffer flameBuffer = CachedBuffers.partial((PartialModel)AllPartialModels.BLAZE_BURNER_FLAME, (BlockState)blockState);
            if (transformStack != null) {
                flameBuffer.transform(transformStack);
            }
            flameBuffer.shiftUVScrolling(spriteShift, uScroll, vScroll);
            VertexConsumer cutout = bufferSource.getBuffer(RenderType.cutoutMipped());
            BlazeBlockRenderer.draw(flameBuffer, horizontalAngle, poseStack, cutout);
        }
        poseStack.popPose();
    }

    protected static void draw(SuperByteBuffer buffer, float horizontalAngle, PoseStack poseStack, VertexConsumer vertexConsumer) {
        ((SuperByteBuffer)buffer.rotateCentered(horizontalAngle, Direction.UP)).light(0xF000F0).renderInto(poseStack, vertexConsumer);
    }

    protected static void drawCentered(SuperByteBuffer buffer, float horizontalAngle, PoseStack poseStack, VertexConsumer vertexConsumer) {
        ((SuperByteBuffer)((SuperByteBuffer)buffer.rotateCentered(horizontalAngle, Direction.UP)).translate(0.5f, 0.0f, 0.5f)).light(0xF000F0).renderInto(poseStack, vertexConsumer);
    }
}

