/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.processing.blaze;

import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.common.processing.blaze.BlazeBlock;
import plus.dragons.createdragonsplus.util.CodeReference;

@CodeReference(value={BlazeBlockEntity.class}, source={"create"}, license={"mit"})
public abstract class BlazeBlockEntity
extends SmartBlockEntity {
    public final LerpedFloat headAnimation = LerpedFloat.linear();
    public final LerpedFloat headAngle = LerpedFloat.angular();

    public BlazeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public abstract boolean isActive();

    public abstract boolean isCreative();

    public abstract BlazeBurnerBlock.HeatLevel getHeatLevel();

    public void tick() {
        super.tick();
        assert (this.level != null);
        if (this.level.isClientSide) {
            if (this.shouldTickAnimation()) {
                this.tickAnimation();
            }
            if (!this.isVirtual()) {
                this.spawnParticles(this.getHeatLevelFromBlock());
            }
            return;
        }
        if (this.isCreative()) {
            return;
        }
        this.updateBlockState();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    protected PartialModel getGogglesModel(BlazeBurnerBlock.HeatLevel heatLevel) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    protected PartialModel getHatModel(BlazeBurnerBlock.HeatLevel heatLevel) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected boolean shouldTickAnimation() {
        return !VisualizationManager.supportsVisualization((LevelAccessor)this.level);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void tickAnimation() {
        boolean active;
        boolean bl = active = this.getHeatLevelFromBlock().isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) && this.isActive();
        if (active) {
            this.headAngle.chase((double)((AngleHelper.horizontalAngle((Direction)this.getBlockState().getOptionalValue((Property)BlazeBurnerBlock.FACING).orElse(Direction.SOUTH)) + 180.0f) % 360.0f), 0.125, LerpedFloat.Chaser.EXP);
            this.headAngle.tickChaser();
        } else {
            float target = 0.0f;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && !player.isInvisible()) {
                double z;
                double x;
                if (this.isVirtual()) {
                    x = -4.0;
                    z = -10.0;
                } else {
                    x = player.getX();
                    z = player.getZ();
                }
                double dx = x - ((double)this.getBlockPos().getX() + 0.5);
                double dz = z - ((double)this.getBlockPos().getZ() + 0.5);
                target = AngleHelper.deg((double)(-Mth.atan2((double)dz, (double)dx))) - 90.0f;
            }
            target = this.headAngle.getValue() + AngleHelper.getShortestAngleDiff((double)this.headAngle.getValue(), (double)target);
            this.headAngle.chase((double)target, 0.25, LerpedFloat.Chaser.exp((double)5.0));
            this.headAngle.tickChaser();
        }
        this.headAnimation.chase(active ? 1.0 : 0.0, 0.25, LerpedFloat.Chaser.exp((double)0.25));
        this.headAnimation.tickChaser();
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevelFromBlock() {
        return BlazeBlock.getHeatLevelOf(this.getBlockState());
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevelForRender() {
        BlazeBurnerBlock.HeatLevel heatLevel = this.getHeatLevelFromBlock();
        if (!heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            return BlazeBurnerBlock.HeatLevel.SMOULDERING;
        }
        return heatLevel;
    }

    public void updateBlockState() {
        this.setBlockHeat(this.getHeatLevel());
    }

    protected void onHeatChange(BlazeBurnerBlock.HeatLevel currentHeat, BlazeBurnerBlock.HeatLevel newHeat) {
    }

    protected void setBlockHeat(BlazeBurnerBlock.HeatLevel newHeat) {
        BlazeBurnerBlock.HeatLevel currentHeat = this.getHeatLevelFromBlock();
        if (currentHeat == newHeat) {
            return;
        }
        assert (this.level != null);
        this.onHeatChange(currentHeat, newHeat);
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(BlazeBlock.HEAT_LEVEL, (Comparable)newHeat));
        this.notifyUpdate();
    }

    protected void playSound() {
        assert (this.level != null);
        this.level.playSound(null, this.worldPosition, SoundEvents.BLAZE_SHOOT, SoundSource.BLOCKS, 0.125f + this.level.random.nextFloat() * 0.125f, 0.75f - this.level.random.nextFloat() * 0.25f);
    }

    protected void spawnParticles(BlazeBurnerBlock.HeatLevel heatLevel) {
        assert (this.level != null);
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        RandomSource random = this.level.getRandom();
        Vec3 center = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        Vec3 smokePos = center.add(VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)random, (float)0.125f).multiply(1.0, 0.0, 1.0));
        if (random.nextInt(4) != 0) {
            return;
        }
        boolean empty = this.level.getBlockState(this.worldPosition.above()).getCollisionShape((BlockGetter)this.level, this.worldPosition.above()).isEmpty();
        if (empty || random.nextInt(8) == 0) {
            this.level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, smokePos.x, smokePos.y, smokePos.z, 0.0, 0.0, 0.0);
        }
        double yMotion = empty ? 0.0625 : random.nextDouble() * (double)0.0125f;
        Vec3 flamePos = center.add(VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)random, (float)0.5f).multiply(1.0, 0.25, 1.0).normalize().scale((empty ? 0.25 : 0.5) + random.nextDouble() * 0.125)).add(0.0, 0.5, 0.0);
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
            this.level.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, flamePos.x, flamePos.y, flamePos.z, 0.0, yMotion, 0.0);
        } else if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, flamePos.x, flamePos.y, flamePos.z, 0.0, yMotion, 0.0);
        }
    }

    protected void spawnParticleBurst(boolean soul) {
        assert (this.level != null);
        Vec3 c = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        RandomSource random = this.level.random;
        for (int i = 0; i < 20; ++i) {
            Vec3 offset = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)random, (float)0.5f).multiply(1.0, 0.25, 1.0).normalize();
            Vec3 pos = c.add(offset.scale(0.5 + random.nextDouble() * 0.125)).add(0.0, 0.125, 0.0);
            Vec3 motion = offset.scale(0.03125);
            this.level.addParticle((ParticleOptions)(soul ? ParticleTypes.SOUL_FIRE_FLAME : ParticleTypes.FLAME), pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
        }
    }
}

