/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.kinetics.fan.sanding;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.common.kinetics.fan.DynamicParticleFanProcessingType;
import plus.dragons.createdragonsplus.common.registry.CDPBlocks;
import plus.dragons.createdragonsplus.common.registry.CDPRecipes;
import plus.dragons.createdragonsplus.config.CDPConfig;
import plus.dragons.createdragonsplus.integration.ModIntegration;

public class SandingFanProcessingType
implements DynamicParticleFanProcessingType<ParticleData> {
    private final DeferredHolder<FanProcessingType, FanProcessingType> createDNDType = ModIntegration.CREATE_DND.fanType("sanding");
    private final DeferredHolder<RecipeType<?>, RecipeType<StandardProcessingRecipe<SingleRecipeInput>>> createDNDRecipe = ModIntegration.CREATE_DND.recipeType("sanding");

    public boolean isValidAt(Level level, BlockPos pos) {
        if (!((Boolean)CDPConfig.recipes().enableBulkSanding.get()).booleanValue()) {
            return false;
        }
        BlockState state = level.getBlockState(pos);
        if (state.is(CDPBlocks.MOD_TAGS.fanSandingCatalysts)) {
            return true;
        }
        return this.createDNDType.isBound() && ((FanProcessingType)this.createDNDType.get()).isValidAt(level, pos);
    }

    public int getPriority() {
        return 700;
    }

    public boolean canProcess(ItemStack stack, Level level) {
        if (!((Boolean)CDPConfig.recipes().enableBulkSanding.get()).booleanValue()) {
            return false;
        }
        RecipeManager recipeManager = level.getRecipeManager();
        SingleRecipeInput input = new SingleRecipeInput(stack);
        Optional recipe = recipeManager.getRecipeFor(CDPRecipes.SANDING.getType(), (RecipeInput)input, level).or(() -> recipeManager.getRecipeFor(AllRecipeTypes.SANDPAPER_POLISHING.getType(), (RecipeInput)input, level)).filter(AllRecipeTypes.CAN_BE_AUTOMATED);
        if (recipe.isPresent()) {
            return true;
        }
        return this.canProcessByCompatRecipe(this.createDNDRecipe, stack, level);
    }

    @Nullable
    public List<ItemStack> process(ItemStack stack, Level level) {
        RecipeManager recipeManager = level.getRecipeManager();
        SingleRecipeInput input = new SingleRecipeInput(stack);
        return recipeManager.getRecipeFor(CDPRecipes.SANDING.getType(), (RecipeInput)input, level).or(() -> recipeManager.getRecipeFor(AllRecipeTypes.SANDPAPER_POLISHING.getType(), (RecipeInput)input, level)).filter(AllRecipeTypes.CAN_BE_AUTOMATED).map(recipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipe.value(), (boolean)true)).or(() -> this.processByCompatRecipe(this.createDNDRecipe, stack, level)).orElse(null);
    }

    @Override
    @Nullable
    public ParticleData getParticleDataAt(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        int color = 14406560;
        Block block = state.getBlock();
        if (block instanceof FallingBlock) {
            FallingBlock falling = (FallingBlock)block;
            color = falling.getDustColor(state, (BlockGetter)level, pos);
        }
        return new ParticleData(state, color);
    }

    @Override
    public void spawnProcessingParticles(Level level, Vec3 pos, @Nullable ParticleData data) {
        if (level.random.nextInt(8) == 0) {
            BlockState state = data == null ? Blocks.SAND.defaultBlockState() : data.state;
            level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, state), pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), 0.0, 0.0, 0.0);
        }
        if (data != null) {
            data.playSound(level, pos);
        }
    }

    @Override
    public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random, @Nullable ParticleData data) {
        int color = data == null ? 14406560 : data.color;
        BlockState state = data == null ? Blocks.SAND.defaultBlockState() : data.state;
        particleAccess.setColor(color);
        particleAccess.setAlpha(1.0f);
        if (random.nextInt(32) == 0) {
            particleAccess.spawnExtraParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, state), 0.0f);
        }
    }

    public void affectEntity(Entity entity, Level level) {
        if (level.isClientSide) {
            return;
        }
        entity.extinguishFire();
    }

    private boolean canProcessByCompatRecipe(DeferredHolder<RecipeType<?>, RecipeType<StandardProcessingRecipe<SingleRecipeInput>>> recipeType, ItemStack stack, Level level) {
        if (!recipeType.isBound()) {
            return false;
        }
        return level.getRecipeManager().getRecipeFor((RecipeType)recipeType.get(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
    }

    private Optional<List<ItemStack>> processByCompatRecipe(DeferredHolder<RecipeType<?>, RecipeType<StandardProcessingRecipe<SingleRecipeInput>>> recipeType, ItemStack stack, Level level) {
        if (!recipeType.isBound()) {
            return Optional.empty();
        }
        return level.getRecipeManager().getRecipeFor((RecipeType)recipeType.get(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipe.value(), (boolean)true));
    }

    public static class ParticleData {
        private final BlockState state;
        private final int color;
        private final Set<BlockPos> playedSoundPos = new ObjectArraySet();

        public ParticleData(BlockState state, int color) {
            this.state = state;
            this.color = color;
        }

        public void playSound(Level level, Vec3 pos) {
            if (level.getGameTime() % 7L == 0L) {
                if (this.playedSoundPos.add(BlockPos.containing((Position)pos))) {
                    AllSoundEvents.SANDING_SHORT.playAt(level, pos, 0.3f + 0.1f * level.random.nextFloat(), 0.9f + 0.2f * level.random.nextFloat(), true);
                }
            } else if (!this.playedSoundPos.isEmpty()) {
                this.playedSoundPos.clear();
            }
        }
    }
}

