/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.network;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import squeek.appleskin.network.MessageExhaustionSync;
import squeek.appleskin.network.MessageSaturationSync;

public class SyncHandler {
    private static final String PROTOCOL_VERSION = "1.0.0";
    private static final Map<UUID, Float> lastSaturationLevels = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> lastExhaustionLevels = new HashMap<UUID, Float>();

    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("appleskin").versioned(PROTOCOL_VERSION).optional();
        registrar.playToClient(MessageExhaustionSync.TYPE, MessageExhaustionSync.CODEC, MessageExhaustionSync::handle);
        registrar.playToClient(MessageSaturationSync.TYPE, MessageSaturationSync.CODEC, MessageSaturationSync::handle);
        NeoForge.EVENT_BUS.register((Object)new SyncHandler());
    }

    @SubscribeEvent
    public void onLivingTickEvent(EntityTickEvent.Pre event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        Float lastSaturationLevel = lastSaturationLevels.get(player.getUUID());
        Float lastExhaustionLevel = lastExhaustionLevels.get(player.getUUID());
        if (lastSaturationLevel == null || lastSaturationLevel.floatValue() != player.getFoodData().getSaturationLevel()) {
            MessageSaturationSync msg = new MessageSaturationSync(player.getFoodData().getSaturationLevel());
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
            lastSaturationLevels.put(player.getUUID(), Float.valueOf(player.getFoodData().getSaturationLevel()));
        }
        float exhaustionLevel = player.getFoodData().getExhaustionLevel();
        if (lastExhaustionLevel == null || Math.abs(lastExhaustionLevel.floatValue() - exhaustionLevel) >= 0.01f) {
            MessageExhaustionSync msg = new MessageExhaustionSync(exhaustionLevel);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
            lastExhaustionLevels.put(player.getUUID(), Float.valueOf(exhaustionLevel));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        lastSaturationLevels.remove(event.getEntity().getUUID());
        lastExhaustionLevels.remove(event.getEntity().getUUID());
    }
}

