/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.entities;

import com.kyanite.deeperdarker.content.DDSounds;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class ShriekWorm
extends Monster {
    public final AnimationState idleState = new AnimationState();
    public final AnimationState attackState = new AnimationState();
    public final AnimationState asleepState = new AnimationState();
    public final AnimationState emergeState = new AnimationState();
    public final AnimationState descendState = new AnimationState();
    private int emergingTime;
    private int idleTime;
    private boolean asleep;

    public ShriekWorm(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.0, true));
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.ATTACK_DAMAGE, 7.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).build();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)DDSounds.SHRIEK_WORM_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)DDSounds.SHRIEK_WORM_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)DDSounds.SHRIEK_WORM_HURT.get();
    }

    public boolean doHurtTarget(Entity entity) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        return super.doHurtTarget(entity);
    }

    public void tick() {
        Player player;
        super.tick();
        if (this.getPose() == Pose.EMERGING && ++this.emergingTime > 80) {
            this.setPose(Pose.STANDING);
        }
        if (this.getPose() == Pose.STANDING && !this.asleep) {
            ++this.idleTime;
            if (this.idleTime > 200) {
                this.idleTime = 0;
                this.asleep = true;
            }
        }
        if ((player = this.level().getNearestPlayer((Entity)this, 5.0)) != null && !player.isDeadOrDying() && !player.isCreative()) {
            this.asleep = false;
        } else if (this.attackState.isStarted() && !this.idleState.isStarted()) {
            this.attackState.stop();
            this.idleState.start(this.tickCount);
        }
        if (this.level().isClientSide()) {
            if (this.asleep && !this.asleepState.isStarted()) {
                this.idleState.stop();
                this.asleepState.start(this.tickCount);
            }
            if (!(this.asleep || this.idleState.isStarted() || this.emergeState.isStarted() || this.descendState.isStarted())) {
                this.asleepState.stop();
                this.idleState.start(this.tickCount);
            }
            if (this.getPose() == Pose.EMERGING) {
                double sX = this.random.nextGaussian() * 0.02;
                double sY = this.random.nextGaussian() * 0.02;
                double sZ = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.getBlockStateOn()), this.getRandomX(1.0), this.getY() + 1.0, this.getRandomZ(1.0), sX, sY, sZ);
            }
        }
        if (this.asleep) {
            this.setBoundingBox(new AABB(this.position().x - 0.5, this.position().y, this.position().z - 0.5, this.position().x + 0.5, this.position().y + 1.6, this.position().z + 0.5));
        } else {
            this.setBoundingBox(new AABB(this.position().x - 0.5, this.position().y, this.position().z - 0.5, this.position().x + 0.5, this.position().y + 5.7, this.position().z + 0.5));
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            this.idleState.stop();
            this.asleepState.stop();
            this.attackState.start(this.tickCount);
        } else {
            super.handleEntityEvent(id);
        }
    }

    public boolean isWithinMeleeAttackRange(LivingEntity entity) {
        return this.getAttackBoundingBox().inflate(6.0, 0.0, 6.0).intersects(entity.getBoundingBox());
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals((Object)DATA_POSE)) {
            if (this.getPose() == Pose.EMERGING) {
                this.emergeState.start(this.tickCount);
            }
            if (this.getPose() == Pose.STANDING) {
                this.emergeState.stop();
            }
        }
        super.onSyncedDataUpdated(key);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, SpawnGroupData spawnGroupData) {
        if (spawnType == MobSpawnType.TRIGGERED) {
            this.setPose(Pose.EMERGING);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public void knockback(double pStrength, double pX, double pZ) {
        this.setDeltaMovement(Vec3.ZERO);
    }
}

