/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.blocks;

import com.kyanite.deeperdarker.content.blocks.entity.CrystallizedAmberBlockEntity;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class CrystallizedAmberBlock
extends BaseEntityBlock {
    public static final MapCodec<CrystallizedAmberBlock> CODEC = CrystallizedAmberBlock.simpleCodec(CrystallizedAmberBlock::new);
    public static final BooleanProperty FOSSILIZED = BooleanProperty.create((String)"fossilized");

    public CrystallizedAmberBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FOSSILIZED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FOSSILIZED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FOSSILIZED, (Comparable)Boolean.valueOf(context.getItemInHand().has(DataComponents.BLOCK_ENTITY_DATA)));
    }

    public boolean skipRendering(BlockState state, BlockState adjacentState, Direction direction) {
        return adjacentState.is((Block)this);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (((Boolean)state.getValue((Property)FOSSILIZED)).booleanValue() && !state.is(oldState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof CrystallizedAmberBlockEntity) {
            CrystallizedAmberBlockEntity blockEntity2 = (CrystallizedAmberBlockEntity)blockEntity;
            blockEntity2.generateFossil(level, pos);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CrystallizedAmberBlockEntity(pos, state);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (stack.has(DataComponents.BLOCK_ENTITY_DATA)) {
            CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
            if (tag.contains("BlockEntityTag")) {
                System.out.println("tagging");
                tag = tag.getCompound("BlockEntityTag");
            }
            if (tag.contains("leech") && tag.getBoolean("leech")) {
                System.out.println("leech");
                tooltipComponents.add((Component)Component.translatable((String)"tooltips.deeperdarker.crystallized_amber.leech").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            } else if (tag.contains("item")) {
                System.out.println("item");
                tooltipComponents.add((Component)Component.translatable((String)"tooltips.deeperdarker.crystallized_amber.item", (Object[])new Object[]{ItemStack.parseOptional((HolderLookup.Provider)context.registries(), (CompoundTag)tag.getCompound("item")).getHoverName()}).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            }
        }
    }
}

