/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.types.color;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.color.HsbColor;
import com.teamresourceful.resourcefulconfig.client.components.options.types.color.HsbState;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class SaturationBrightnessSelector
extends BaseWidget {
    private final HsbState state;

    public SaturationBrightnessSelector(int width, int height, HsbState state) {
        super(width, height);
        this.state = state;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        HsbColor color = this.state.get();
        int posX = Math.round(color.saturation() * (float)this.getWidth());
        int posY = this.getHeight() - Math.round(color.brightness() * (float)this.getHeight());
        int tileWidth = Math.round((float)this.getWidth() / 10.0f);
        int tileHeight = Math.round((float)this.getHeight() / 10.0f);
        for (int dy = 0; dy < 10; ++dy) {
            float minB = (float)dy / 10.0f;
            float maxB = (float)(dy + 1) / 10.0f;
            for (int dx = 0; dx < 10; ++dx) {
                float minS = (float)dx / 10.0f;
                float maxS = (float)(dx + 1) / 10.0f;
                this.drawGradient(graphics, this.getX() + dx * tileWidth, this.getY() + (10 - dy - 1) * tileHeight, tileWidth, tileHeight, HsbColor.of(color.hue(), minS, maxB, 255).toRgba(), HsbColor.of(color.hue(), maxS, maxB, 255).toRgba(), HsbColor.of(color.hue(), minS, minB, 255).toRgba(), HsbColor.of(color.hue(), maxS, minB, 255).toRgba());
            }
        }
        graphics.renderOutline(this.getX() + posX - 1, this.getY() + posY - 1, 3, 3, -16777216);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        int x = (int)mouseX - this.getX();
        int y = (int)mouseY - this.getY();
        if (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight()) {
            return false;
        }
        this.state.set(HsbColor.of(this.state.get().hue(), Mth.clamp((float)((float)x / (float)this.getWidth()), (float)0.0f, (float)1.0f), 1.0f - Mth.clamp((float)((float)y / (float)this.getHeight()), (float)0.0f, (float)1.0f), 255));
        return true;
    }

    public boolean mouseDragged(double d, double e, int i, double f, double g) {
        return this.mouseClicked(d, e, i);
    }

    private void drawGradient(GuiGraphics graphics, int x, int y, int width, int height, int topLeft, int topRight, int bottomLeft, int bottomRight) {
        Matrix4f matrix4f = graphics.pose().last().pose();
        VertexConsumer buffer = graphics.bufferSource().getBuffer(RenderType.gui());
        buffer.addVertex(matrix4f, (float)x, (float)(y + height), 0.0f).setColor(bottomLeft);
        buffer.addVertex(matrix4f, (float)(x + width), (float)(y + height), 0.0f).setColor(bottomRight);
        buffer.addVertex(matrix4f, (float)(x + width), (float)y, 0.0f).setColor(topRight);
        buffer.addVertex(matrix4f, (float)x, (float)y, 0.0f).setColor(topLeft);
        graphics.flush();
    }
}

