/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.api.types.options;

import java.util.function.BiConsumer;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public record TranslatableValue(String value, String translation) {
    public static final TranslatableValue EMPTY = new TranslatableValue("", "");

    public TranslatableValue(String value) {
        this(value, "");
    }

    public void ifPresent(BiConsumer<String, String> value) {
        if (!this.value.isBlank()) {
            value.accept(this.value, this.translation);
        }
    }

    public MutableComponent toComponent() {
        if (this.translation().isBlank()) {
            return Component.literal((String)this.value());
        }
        return Component.translatable((String)this.translation());
    }

    public String toLocalizedString() {
        if (this.translation().isBlank()) {
            return this.value();
        }
        return Language.getInstance().getOrDefault(this.translation());
    }

    public boolean hasTranslation() {
        return !this.translation().isBlank();
    }
}

