/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.event;

import com.mrh0.createaddition.blocks.liquid_blaze_burner.LiquidBlazeBurnerBlock;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyManager;
import com.mrh0.createaddition.debug.CADebugger;
import com.mrh0.createaddition.energy.network.EnergyNetworkManager;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.index.CAItems;
import com.mrh0.createaddition.network.ObservePacketPayload;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber
public class GameEvents {
    private static final Direction[] horizontalDirections = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    @SubscribeEvent
    public static void levelTickEvent(LevelTickEvent.Pre evt) {
        if (evt.getLevel().isClientSide()) {
            return;
        }
        EnergyNetworkManager.tickWorld((LevelAccessor)evt.getLevel());
    }

    @SubscribeEvent
    public static void serverTickEvent(ServerTickEvent.Pre evt) {
        PortableEnergyManager.tick();
    }

    @SubscribeEvent
    public static void clientTickEvent(ClientTickEvent.Post evt) {
        ObservePacketPayload.tick();
        CADebugger.tick();
    }

    @SubscribeEvent
    public static void loadEvent(LevelEvent.Load evt) {
        if (evt.getLevel().isClientSide()) {
            return;
        }
        new EnergyNetworkManager(evt.getLevel());
    }

    @SubscribeEvent
    public static void LevelUnload(LevelEvent.Unload event) {
        if (!event.getLevel().isClientSide()) {
            EnergyNetworkManager.instances.remove(event.getLevel());
        }
    }

    @SubscribeEvent
    public static void interact(PlayerInteractEvent.RightClickBlock evt) {
        try {
            if (evt.getLevel().isClientSide()) {
                return;
            }
            BlockState state = evt.getLevel().getBlockState(evt.getPos());
            if (evt.getItemStack().getItem() == CAItems.STRAW.get() && evt.getLevel().getBlockEntity(evt.getPos()) instanceof BlazeBurnerBlockEntity && state.is((Block)AllBlocks.BLAZE_BURNER.get())) {
                BlockState newState = (BlockState)((BlockState)CABlocks.LIQUID_BLAZE_BURNER.getDefaultState().setValue((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.SMOULDERING)).setValue((Property)LiquidBlazeBurnerBlock.FACING, (Comparable)((Direction)state.getValue((Property)BlazeBurnerBlock.FACING)));
                evt.getLevel().setBlockAndUpdate(evt.getPos(), newState);
                if (!evt.getEntity().isCreative()) {
                    evt.getItemStack().shrink(1);
                }
                evt.setCancellationResult(InteractionResult.SUCCESS);
                evt.setCanceled(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

