/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem.platform;

import com.affehund.voidtotem.VoidTotemForge;
import com.affehund.voidtotem.config.VoidTotemCommonConfig;
import com.affehund.voidtotem.network.TotemEffectPacket;
import com.affehund.voidtotem.platform.services.IPlatformHelper;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public Item getVoidTotemItem() {
        return (Item)VoidTotemForge.VOID_TOTEM_ITEM.get();
    }

    @Override
    public ParticleOptions getVoidTotemParticleOptions() {
        return (ParticleOptions)VoidTotemForge.VOID_TOTEM_PARTICLE.get();
    }

    @Override
    public ItemStack getTotemFromAdditionalSlot(LivingEntity livingEntity, Predicate<ItemStack> filter) {
        if (this.isModLoaded("curios")) {
            return CuriosApi.getCuriosInventory((LivingEntity)livingEntity).map(inv -> inv.findFirstCurio(filter).map(SlotResult::stack).orElse(null)).orElse(null);
        }
        return null;
    }

    @Override
    public List<? extends String> getBlocklistedDimensions() {
        return (List)VoidTotemCommonConfig.BLOCKLISTED_DIMENSIONS.get();
    }

    @Override
    public boolean isInvertedBlocklist() {
        return (Boolean)VoidTotemCommonConfig.IS_INVERTED_BLOCKLIST.get();
    }

    @Override
    public int teleportHeightOffset() {
        return (Integer)VoidTotemCommonConfig.TELEPORT_HEIGHT_OFFSET.get();
    }

    @Override
    public boolean useTotemFromInventory() {
        return (Boolean)VoidTotemCommonConfig.USE_TOTEM_FROM_INVENTORY.get();
    }

    @Override
    public void sendTotemEffectPacket(ItemStack itemStack, LivingEntity livingEntity) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)livingEntity, (CustomPacketPayload)new TotemEffectPacket(itemStack, livingEntity.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

