/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem.data;

import com.affehund.voidtotem.VoidTotemForge;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.UsedTotemTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VoidTotemDataGeneration {

    public static final class RecipeGen
    extends RecipeProvider {
        public RecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
            super(output, registries);
        }

        protected void buildRecipes(@NotNull RecipeOutput recipeOutput) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)VoidTotemForge.VOID_TOTEM_ITEM.get())).pattern("cec").pattern("ltl").pattern(" e ").define(Character.valueOf('c'), (ItemLike)Items.CHORUS_FRUIT).define(Character.valueOf('e'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('l'), (ItemLike)Items.LAPIS_LAZULI).define(Character.valueOf('t'), (ItemLike)Items.TOTEM_OF_UNDYING).unlockedBy("has_totem", RecipeGen.has((ItemLike)Items.TOTEM_OF_UNDYING)).save(recipeOutput);
        }
    }

    public static class BlockTagsGen
    extends BlockTagsProvider {
        public BlockTagsGen(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "voidtotem", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider p_256380_) {
        }
    }

    public static class AdvancementGen
    implements AdvancementProvider.AdvancementGenerator {
        public void generate(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, @NotNull Consumer<AdvancementHolder> consumer, @NotNull ExistingFileHelper existingFileHelper) {
            Advancement.Builder.advancement().parent(Advancement.Builder.advancement().build(ResourceLocation.withDefaultNamespace((String)"adventure/totem_of_undying"))).display((ItemLike)VoidTotemForge.VOID_TOTEM_ITEM.get(), (Component)Component.translatable((String)"advancements.voidtotem.adventure.totem_of_void_undying.title"), (Component)Component.translatable((String)"advancements.voidtotem.adventure.totem_of_void_undying.description"), null, AdvancementType.GOAL, true, true, false).addCriterion("used_void_totem", UsedTotemTrigger.TriggerInstance.usedTotem((ItemLike)((ItemLike)VoidTotemForge.VOID_TOTEM_ITEM.get()))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"voidtotem", (String)"adventure/totem_of_void_undying"), existingFileHelper);
        }
    }

    public static final class ItemModelGen
    extends ItemModelProvider {
        public ItemModelGen(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
            super(packOutput, "voidtotem", existingFileHelper);
        }

        protected void registerModels() {
            this.singleTexture((Item)VoidTotemForge.VOID_TOTEM_ITEM.get());
        }

        private void singleTexture(Item item) {
            ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)item);
            this.singleTexture(Objects.requireNonNull(registryName).getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"), "layer0", this.modLoc("item/" + registryName.getPath()));
        }
    }

    public static final class LanguageGen
    extends LanguageProvider {
        public LanguageGen(PackOutput packOutput, String locale) {
            super(packOutput, "voidtotem", locale);
        }

        protected void addTranslations() {
            String locale;
            switch (locale = this.getName().replace("Languages: ", "")) {
                case "de_de": {
                    this.add("_comment", "Translation (de_de) by Affehund");
                    this.add((Item)VoidTotemForge.VOID_TOTEM_ITEM.get(), "Totem der Unsterblichkeit in der Leere");
                    this.add("tooltip.voidtotem.totem_of_void_undying", "Lege es in deine Haupt-/Nebenhand, um zu verhindern zu sterben, wenn du in die Leere f\u00e4llst.");
                    this.add("advancements.voidtotem.adventure.totem_of_void_undying.title", "Post mortem 2");
                    this.add("advancements.voidtotem.adventure.totem_of_void_undying.description", "Benutze ein Totem der Unsterblichkeit in der Leere, um dem Tod, wenn du in die Leere f\u00e4llst, von der Schippe zu springen");
                    this.add("trinkets.slot.charm.charm", "Amulett");
                    break;
                }
                case "en_us": {
                    this.add("_comment", "Translation (en_us) by Affehund");
                    this.add((Item)VoidTotemForge.VOID_TOTEM_ITEM.get(), "Totem of Void Undying");
                    this.add("tooltip.voidtotem.totem_of_void_undying", "Put in your main-/offhand to prevent dying if you fall in the void.");
                    this.add("advancements.voidtotem.adventure.totem_of_void_undying.title", "Postmortal 2");
                    this.add("advancements.voidtotem.adventure.totem_of_void_undying.description", "Use a Totem of Void Undying to cheat death when falling in the void");
                    this.add("trinkets.slot.charm.charm", "Charm");
                    this.addAutoConfigOption("ADD_END_CITY_TREASURE");
                    this.addAutoConfigOption("BLOCKLISTED_DIMENSIONS");
                    this.addAutoConfigOption("DISPLAY_TOTEM_ON_CHEST");
                    this.addAutoConfigOption("GIVE_TOTEM_EFFECTS");
                    this.addAutoConfigOption("IS_INVERTED_BLOCKLIST");
                    this.addAutoConfigOption("NEEDS_TOTEM");
                    this.addAutoConfigOption("SHOW_TOTEM_TOOLTIP");
                    this.addAutoConfigOption("TELEPORT_HEIGHT_OFFSET");
                    this.addAutoConfigOption("USE_TOTEM_FROM_INVENTORY");
                }
            }
        }

        private void addAutoConfigOption(String key) {
            this.add("text.autoconfig.voidtotem.option." + key, StringUtils.capitalizeFirstLetter((String)key.toLowerCase(Locale.ROOT).replace("_", " ")));
        }
    }
}

