/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem.core;

import com.affehund.voidtotem.core.ILivingEntityMixin;
import com.affehund.voidtotem.mixin.ServerGamePacketListenerImplAccessor;
import com.affehund.voidtotem.platform.Services;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class ModUtils {
    public static boolean isModLoaded(String modId) {
        return Services.PLATFORM.isModLoaded(modId);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean canProtectFromVoid(LivingEntity entity, DamageSource source) {
        currentDim = entity.level().dimension().location().toString();
        isBlocklisted = Services.PLATFORM.isInvertedBlocklist() != Services.PLATFORM.getBlocklistedDimensions().contains(currentDim);
        v0 = isInVoid = source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) != false && entity.getY() < (double)entity.level().getMinBuildHeight();
        if (!(entity instanceof ServerPlayer)) ** GOTO lbl-1000
        player = (ServerPlayer)entity;
        if (((ServerGamePacketListenerImplAccessor)player.connection).getAwaitingPositionFromClient() != null) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        isAwaitingPosition = v1;
        return isBlocklisted == false && isInVoid != false && isAwaitingPosition == false && ModUtils.hasVoidTotem(entity) != false;
    }

    public static void handleVoidTotem(LivingEntity entity) {
        ItemStack stack = ModUtils.getTotemItemStack(entity);
        if (stack != null) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ModUtils.resetAboveGroundTickCount(player);
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                CriteriaTriggers.USED_TOTEM.trigger(player, stack);
                player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
            }
            stack = ModUtils.shrinkItemStack(stack, entity);
            ModUtils.resetEntityState(entity);
            ModUtils.teleportToSavePosition(entity);
            Services.PLATFORM.sendTotemEffectPacket(stack, entity);
        }
    }

    public static void handleDefaultTotemActivation(LivingEntity entity) {
        ItemStack stack = ModUtils.getTotemItemStack(entity);
        if (stack != null) {
            stack = ModUtils.shrinkItemStack(stack, entity);
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                CriteriaTriggers.USED_TOTEM.trigger(player, new ItemStack((ItemLike)Items.TOTEM_OF_UNDYING));
                entity.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
            }
            entity.setHealth(1.0f);
            ModUtils.giveTotemEffects(entity, true);
            Services.PLATFORM.sendTotemEffectPacket(stack, entity);
        }
    }

    public static boolean hasVoidTotem(LivingEntity entity) {
        return ModUtils.getTotemItemStack(entity) != null;
    }

    public static void setLastSaveBlockPos(LivingEntity entity) {
        Level level = entity.level();
        BlockPos currentPos = entity.blockPosition();
        BlockPos lastPos = BlockPos.of((long)((ILivingEntityMixin)entity).voidtotem$getLastSaveBlockPosAsLong());
        if (!(!ModUtils.isSaveBlockPos(level, currentPos.below()) || lastPos.equals((Object)currentPos) && ModUtils.isSaveBlockPos(level, lastPos.below()))) {
            ((ILivingEntityMixin)entity).voidtotem$setLastSaveBlockPosAsLong(currentPos.asLong());
            ((ILivingEntityMixin)entity).voidtotem$setLastSaveBlockDim(entity.level().dimensionType());
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void resetFallDamageImmunity(LivingEntity entity) {
        if (!((ILivingEntityMixin)entity).voidtotem$isFallDamageImmune()) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) ** GOTO lbl-1000
        player = (ServerPlayer)entity;
        if (player.getAbilities().flying || player.getAbilities().mayfly) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        canFly = v0;
        isInWater = entity.isInWater();
        isInCobweb = entity.level().getBlockState(entity.blockPosition()).is(Blocks.COBWEB);
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            ModUtils.resetAboveGroundTickCount(player);
        }
        if (canFly || isInCobweb || isInWater) {
            ((ILivingEntityMixin)entity).voidtotem$setFallDamageImmune(false);
        }
    }

    public static void playActivateAnimation(ItemStack itemStack, int entityId) {
        Entity entity;
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level != null && (entity = mc.level.getEntity(entityId)) != null) {
            mc.particleEngine.createTrackingEmitter(entity, Services.PLATFORM.getVoidTotemParticleOptions(), 30);
            level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), SoundEvents.TOTEM_USE, entity.getSoundSource(), 1.0f, 1.0f, false);
            if (entity == mc.player) {
                mc.gameRenderer.displayItemActivation(itemStack);
            }
        }
    }

    private static void resetEntityState(LivingEntity entity) {
        entity.stopRiding();
        entity.ejectPassengers();
        entity.setHealth(1.0f);
        ((ILivingEntityMixin)entity).voidtotem$setFallDamageImmune(true);
        ModUtils.giveTotemEffects(entity, false);
    }

    private static ItemStack shrinkItemStack(ItemStack stack, LivingEntity entity) {
        ServerPlayer player;
        ItemStack copiedStack = stack.copy();
        if (!(entity instanceof ServerPlayer) || !(player = (ServerPlayer)entity).isCreative()) {
            stack.shrink(1);
        }
        return copiedStack;
    }

    private static ItemStack getTotemItemStack(LivingEntity entity) {
        return Stream.of(ModUtils.getAdditionalTotems(entity), ModUtils.getTotemFromInventory(entity), ModUtils.getTotemFromHands(entity)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static ItemStack getAdditionalTotems(LivingEntity entity) {
        return Services.PLATFORM.getTotemFromAdditionalSlot(entity, ModUtils::isVoidTotemItem);
    }

    private static ItemStack getTotemFromInventory(LivingEntity entity) {
        if (Services.PLATFORM.useTotemFromInventory() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return player.getInventory().items.stream().filter(ModUtils::isVoidTotemItem).findFirst().orElse(null);
        }
        return null;
    }

    private static ItemStack getTotemFromHands(LivingEntity entity) {
        return Arrays.stream(InteractionHand.values()).map(arg_0 -> ((LivingEntity)entity).getItemInHand(arg_0)).filter(ModUtils::isVoidTotemItem).findFirst().orElse(null);
    }

    private static void giveTotemEffects(LivingEntity entity, boolean giveFireRes) {
        entity.removeAllEffects();
        entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
        entity.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
        if (giveFireRes) {
            entity.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
        }
    }

    private static boolean isVoidTotemItem(ItemStack stack) {
        return stack.getItem().equals(Services.PLATFORM.getVoidTotemItem());
    }

    private static void teleportToSavePosition(LivingEntity entity) {
        BlockPos lastPos = ModUtils.getNearLastPos(entity);
        if (lastPos != null) {
            entity.teleportTo((double)lastPos.getX(), (double)lastPos.getY(), (double)lastPos.getZ());
        } else {
            BlockPos currentPos = entity.blockPosition();
            entity.teleportTo((double)currentPos.getX(), (double)(entity.level().getMaxBuildHeight() + Services.PLATFORM.teleportHeightOffset()), (double)currentPos.getZ());
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ModUtils.resetAboveGroundTickCount(player);
            }
        }
    }

    private static BlockPos getNearLastPos(LivingEntity entity) {
        BlockPos lastPos = BlockPos.of((long)((ILivingEntityMixin)entity).voidtotem$getLastSaveBlockPosAsLong());
        Level level = entity.level();
        if (((ILivingEntityMixin)entity).voidtotem$getLastSaveBlockDim() == level.dimensionType()) {
            return IntStream.range(0, 16).mapToObj(i -> {
                double x = (double)lastPos.getX() + (entity.getRandom().nextDouble() - 0.5) * 16.0;
                double y = Mth.clamp((int)(lastPos.getY() + entity.getRandom().nextInt(16) - 8), (int)level.getMinBuildHeight(), (int)(level.getMaxBuildHeight() - 1));
                double z = (double)lastPos.getZ() + (entity.getRandom().nextDouble() - 0.5) * 16.0;
                return new BlockPos((int)x, (int)y, (int)z);
            }).filter(pos -> entity.randomTeleport((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), false)).findFirst().orElse(null);
        }
        return null;
    }

    private static boolean isSaveBlockPos(@NotNull Level level, BlockPos pos) {
        return level.getBlockState(pos).isRedstoneConductor((BlockGetter)level, pos);
    }

    private static void resetAboveGroundTickCount(ServerPlayer player) {
        ((ServerGamePacketListenerImplAccessor)player.connection).setAboveGroundTickCount(0);
    }
}

