/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.neoforge.handler;

import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.config.ServerConfig;
import fuzs.pickupnotifier.network.S2CTakeItemMessage;
import fuzs.pickupnotifier.network.S2CTakeItemStackMessage;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;

public class NeoForgeItemPickupHandler {
    private static ItemStack currentStack = ItemStack.EMPTY;

    public static void onEntityItemPickup$1(ItemEntityPickupEvent.Pre evt) {
        ItemStack itemStack;
        if (((ServerConfig)PickUpNotifier.CONFIG.get(ServerConfig.class)).backpackCompat && !(itemStack = evt.getItemEntity().getItem()).isEmpty() && !evt.getItemEntity().isRemoved()) {
            currentStack = itemStack.copy();
        }
    }

    public static void onEntityItemPickup$2(ItemEntityPickupEvent.Pre evt) {
        ItemEntity itemEntity = evt.getItemEntity();
        Player player = evt.getPlayer();
        ItemStack stack = itemEntity.getItem();
        if (((ServerConfig)PickUpNotifier.CONFIG.get(ServerConfig.class)).backpackCompat && evt.canPickup() != TriState.DEFAULT) {
            if (!currentStack.isEmpty()) {
                boolean sendTakeMessage = false;
                int takeAmount = currentStack.getCount() - stack.getCount();
                if (takeAmount > 0) {
                    currentStack.setCount(takeAmount);
                    sendTakeMessage = true;
                } else if (itemEntity.isRemoved()) {
                    sendTakeMessage = true;
                }
                if (sendTakeMessage) {
                    PickUpNotifier.NETWORK.sendTo((ServerPlayer)player, new S2CTakeItemStackMessage(currentStack).toClientboundMessage());
                }
            }
            currentStack = ItemStack.EMPTY;
        } else if (((ServerConfig)PickUpNotifier.CONFIG.get(ServerConfig.class)).partialPickUps && !itemEntity.isRemoved() && !itemEntity.hasPickUpDelay() && (itemEntity.getOwner() == null || itemEntity.lifespan - itemEntity.getAge() <= 200 || itemEntity.getOwner().equals((Object)player.getUUID()))) {
            int itemAmount = 0;
            if (player.getInventory().getFreeSlot() != -1) {
                itemAmount = stack.getCount();
            } else {
                int slotWithRemainingSpace = player.getInventory().getSlotWithRemainingSpace(stack);
                if (slotWithRemainingSpace != -1) {
                    itemAmount = NeoForgeItemPickupHandler.getSpaceAtIndex(player.getInventory(), slotWithRemainingSpace, stack);
                }
            }
            if (itemAmount > 0) {
                PickUpNotifier.NETWORK.sendTo((ServerPlayer)player, new S2CTakeItemMessage(itemEntity.getId(), itemAmount).toClientboundMessage());
            }
        }
    }

    public static void onPlayerItemPickup(ItemEntityPickupEvent.Post evt) {
        if (!((ServerConfig)PickUpNotifier.CONFIG.get(ServerConfig.class)).partialPickUps && !evt.getItemEntity().isRemoved()) {
            PickUpNotifier.NETWORK.sendTo((ServerPlayer)evt.getPlayer(), new S2CTakeItemMessage(evt.getItemEntity().getId(), evt.getOriginalStack().getCount()).toClientboundMessage());
        }
    }

    private static int getSpaceAtIndex(Inventory inventory, int slotIndex, ItemStack stack) {
        int itemCount = stack.getCount();
        ItemStack itemstack = inventory.getItem(slotIndex);
        int itemSpace = itemCount;
        if (itemCount > itemstack.getMaxStackSize() - itemstack.getCount()) {
            itemSpace = itemstack.getMaxStackSize() - itemstack.getCount();
        }
        if (itemSpace > inventory.getMaxStackSize() - itemstack.getCount()) {
            itemSpace = inventory.getMaxStackSize() - itemstack.getCount();
        }
        return itemSpace;
    }
}

